;
; this is a public domain 60 byte nibbles game written by chem of hubris
; for the hugi size coding competition (http://hugi-compo.home.pages.de).
;
; chemhubris@hotmail.com, http://www.pcuf.fi/~chem/
;
; keyboard's numerical pad:
;
;      upwards.......8
;      downwards.....2
;      leftwards.....4
;      rightwards....6
;

title chemnibb                             ; compile: tasm /m4, tlink /t

ideal
model tiny                                 ; tiny

codeseg
  org 100h                                 ; .com
  p286                                     ; !!

hugi_nibbles:
  inc di                                   ; 1 byte, set di = -1

  mov al,013h                              ; 2 bytes, set 320x200x256
  int 010h                                 ; 2 bytes

  push 0A000h                              ; 3 bytes, set es = 0A000h
  pop es                                   ; 1 byte

  mov cl,199d                              ; 2 bytes, left+right borders
vertical_borders:
  stosb                                    ; 1 byte
  stosb                                    ; 1 byte
  add di,318d                              ; 4 bytes
  loop vertical_borders                    ; 2 bytes

  mov cx,2177d                             ; 3 bytes, up+down borders
  rep stosb                                ; 2 bytes

lets_start:
  mov ah,0Bh                               ; 2 bytes, check retrace
  int 010h                                 ; 2 bytes

  in al,060h                               ; 2 bytes, read keyboard
  and al,14d                               ; 2 bytes
  jz no_xor_al                             ; 2 bytes
  xor al,14d                               ; 2 bytes
no_xor_al:
  xchg ax,bx                               ; 1 byte

  add di,[offset directions - 0B00h + bx]  ; 4 bytes, move worm

  xor [es:di],bh                           ; 3 bytes, check'n'draw worm
  jnp lets_start                           ; 2 bytes

  mov ax,03h                               ; 3 bytes, set textmode
  int 010h                                 ; 2 bytes

  retn                                     ; 1 byte, exit, no crashing

  directions dw 320d                       ; 2 bytes, down
             dw 1d                         ; 2 bytes, right
             dw -1d                        ; 2 bytes, left
             dw -320d                      ; 2 bytes, up

end hugi_nibbles

ends