WAITKEY PROC
        push    eax
        xor     ah,ah
        int     16h
        pop     eax
        ret
WAITKEY ENDP

CHECKKEY PROC
        clc
        push    eax
        mov     ah,11h
        int     16h
        jz      checkkey_end
        stc
checkkey_end:
        pop     eax
        ret
CHECKKEY ENDP

CLEAR_KEYBUFFER PROC
clear_keybuffer_l1:
        call    checkkey
        jnc     clear_keybuffer_ready
        call    waitkey
        call    clear_keybuffer_l1
clear_keybuffer_ready:
        ret
CLEAR_KEYBUFFER ENDP

FADEDOWN PROC
        xor     eax,eax
        xor     ebx,ebx
        xor     ecx,ecx
        xor     edx,edx
        mov     ebp,64
fadedown_l2:
        call    wait_retrace
        mov     bl,[fadedown_cols]
fadedown_l1:
        mov     al,bl                   ;bl:color
        dec     al
        mov     edx,3c7h               ;fades bl one down
        out     dx,al
        mov     edx,3c9h
        in      al,dx
        test    al,al
        jz      fadedown_skipr
        dec     al
fadedown_skipr:
        mov     cl,al
        in      al,dx
        test    al,al
        jz      fadedown_skipg
        dec     al
fadedown_skipg:
        mov     ch,al
        in      al,dx
        test    al,al
        jz      fadedown_skipb
        dec     al
fadedown_skipb:
        mov     bh,al

        mov     al,bl
        dec     al
        mov     edx,3c8h
        out     dx,al
        mov     edx,3c9h
        mov     al,cl
        out     dx,al
        mov     al,ch
        out     dx,al
        mov     al,bh
        out     dx,al

        dec     bl
        jnz     fadedown_l1
        dec     ebp
        jnz     fadedown_l2

        ret
FADEDOWN ENDP


GET_HI_MEM PROC                                 ; Gets some high mem. (riplin)
        ;In: ECX= ammount of mem in 1byte blocks.
        ;Out: EBX = pointer to mem.
        ;       ESI = handle (HIMEM HANDLE!!!)
        ;if Carry set: EDX = pointer to err msg. Call mem_graph_err
        ;                    then abort current current activity.
        mov     ebx,ecx
        shr     ebx,16
        mov     eax,0501h
        int     31h
        jc      get_hi_err
        shl     esi,16
        shl     ebx,16
        mov     si,di
        mov     bx,cx
        clc
        ret
get_hi_err:
        mov     edx,offset ermsg1
        stc
        ret
GET_HI_MEM ENDP

FREE_HI_MEM PROC                                ;(riplin)
        ;In: ESI=Handle.
        ;Out: Nothing.
        mov     di,si
        shr     esi,16
        mov     eax,0502h
        int     31h
        clc
        ret
FREE_HI_MEM ENDP

CLEAR PROC
        ;in:    edi:destination
        ;       ecx:size
        ;       eax:color
        shr     ecx,2
        push    bx
        mov     ah,al
        mov     bx,ax
        shl     eax,16
        mov     ax,bx
        push    es
        push    ds
        pop     es
        rep     stosd
        pop     es
        pop     bx
        ret
CLEAR ENDP

FLIP PROC
        ;in:            esi:source
        ;               edi:destination
        push    ecx
        mov     ecx,16000
        push    es
        push    ds
        pop     es
        rep     movsd
        pop     es
        pop     ecx
        ret
FLIP ENDP

SMALLFLIP PROC
        ;in:            esi:source
        ;               edi:destination
        push    ecx
        mov     ecx,16000-320*2
        add     edi,320*4
        add     esi,320*4
        push    es
        push    ds
        pop     es
        rep     movsd
        pop     es
        pop     ecx
        ret
SMALLFLIP ENDP

MELT PROC
        push    ecx
        push    eax
        mov     ecx,320*200
melt_l1:
        mov     al,[esi+ecx]
        cmp     al,255
        jne     melt_ne1
melt_nc1:
        add     byte ptr[edi+ecx],40
melt_ne1:
        dec     ecx
        jnz     melt_l1

        pop     eax
        pop     ecx

        ret
MELT ENDP

VADD PROC
        ;in:            esi:source
        ;               edi:destination
        ;               al:color in source NOT to copy
        push    ecx
        push    eax
        clc
        mov     ecx,320*200
vadd_l1:
        mov     ah,[esi+ecx]
        cmp     ah,al
        je      vadd_not
        mov     [edi+ecx],ah
vadd_not:
        dec     ecx
        jnz     vadd_l1

        pop     eax
        pop     ecx
        ret
VADD ENDP

VADD2 PROC
        ;in:            esi:source
        ;               edi:destination
        ;               al:color in source NOT to copy
        push    ecx
        push    eax
        clc
        mov     ecx,320*200
vadd2_l1:
        mov     ah,[esi+ecx]
        cmp     ah,al
        jbe     vadd2_not
        mov     [edi+ecx],ah
vadd2_not:
        dec     ecx
        jnz     vadd2_l1

        pop     eax
        pop     ecx
        ret
VADD2 ENDP


WAIT_RETRACE proc
        push    dx
        push    ax
        mov     dx,3dah
@l1:    in      al,dx
        and     al,08h
        jnz     @l1
@l2:    in      al,dx
        and     al,08h
        jz      @l2
        pop     ax
        pop     dx
        ret
WAIT_RETRACE endp


BLUR_ALL PROC
        ;in:            edi:destination
        xor     ebx,ebx
        xor     edx,edx

        xor     eax,eax
        mov     al,byte ptr [edi+319]
        mov     bl,byte ptr [edi+320*199]
        add     eax,ebx
        mov     bl,byte ptr [edi+1]
        mov     dl,byte ptr [edi+320]
        add     eax,ebx
        add     eax,edx
        shr     eax,2
        cmp     eax,70
        jb      ba_max1ok
        mov     eax,70
BA_MAX1OK:
        mov     [edi],al
        inc     edi

        mov     ecx,319
blur_allloop1:
        xor     eax,eax
        mov     al,byte ptr [edi+320]
        mov     bl,byte ptr [edi+320*199]
        add     eax,ebx
        mov     bl,byte ptr [edi-1]
        mov     dl,byte ptr [edi+1]
        add     eax,ebx
        add     eax,edx
        shr     eax,2
        cmp     eax,70
        jb      ba_max2OK
        mov     eax,70
ba_max2ok:
        mov     [edi],al
        inc     edi
        dec     ecx
        JNZ     BLUR_ALLLOOP1

        mov     ecx,63360
        xor     edx,edx
blur_allloop2:
        xor     eax,eax
        mov     al,byte ptr [edi+320]
        mov     bl,byte ptr [edi-320]
        add     eax,ebx
        mov     bl,byte ptr [edi-1]
        mov     dl,byte ptr [edi+1]
        add     eax,ebx
        add     eax,edx
        shr     eax,2
        cmp     eax,70
        jb      ba_max3OK
        mov     eax,70
ba_max3ok:
        mov     [edi],al
        inc     edi
        dec     ecx
        JNZ     BLUR_ALLLOOP2

        mov     ecx,319
blur_allloop3:
        xor     eax,eax
        mov     al,byte ptr [edi-320]
        mov     bl,byte ptr [edi-320*199]
        add     eax,ebx
        mov     bl,byte ptr [edi-1]
        mov     dl,byte ptr [edi+1]
        add     eax,ebx
        add     eax,edx
        shr     eax,2
        cmp     eax,70
        jb      ba_max4OK
        mov     eax,70
ba_max4ok:
        mov     [edi],al
        inc     edi
        dec     ecx
        JNZ     BLUR_ALLLOOP3


        xor     eax,eax
        mov     al,byte ptr [edi-319]
        mov     bl,byte ptr [edi-320*199]
        add     eax,ebx
        mov     bl,byte ptr [edi-1]
        mov     dl,byte ptr [edi-320]
        add     eax,ebx
        add     eax,edx
        shr     eax,2
        cmp     eax,70
        jb      ba_max5OK
        mov     eax,70
ba_max5ok:
        mov     [edi],al
        inc     edi

        ret
BLUR_ALL ENDP

BLUR PROC
        xor     ebx,ebx
        mov     ecx,63360
        add     edi,320
        xor     edx,edx
blurloop:
        xor     eax,eax
        mov     al,[edi+320]
        mov     bl,[edi-320]
        add     eax,ebx
        mov     bl,[edi-1]
        mov     dl,[edi+1]
        add     eax,ebx
        add     eax,edx
        shr     eax,2
        mov     [edi],al
        inc     edi
        dec     ecx
        jnz     blurloop
        ret
BLUR ENDP
