#ifndef _HEIGHTFIELD_H
#define _HEIGHTFIELD_H

#include "mathlib.h"

#define HEIGHTFIELD_TEXTURE 4

#ifndef NONE
#define NONE 0
#endif

#define SETTLE 1
#define WAVY1 2

#define SETTLE_SPEED 3.0
#define SETTLE_FACTOR 0.8
#define SETTLE_THRESHOLD 0.6

#define FREQUENCY_1 -2.0
#define WAVELENGTH_1 30.0
#define AMPLITUDE_1 10.0

extern vec3_t viewvect;
extern vec3_t lightvect;
extern float framedelta;
extern int lastframe;

typedef int hfieldeffect;

typedef short face_t[3];
typedef float tcoord_t[2];

typedef struct heightfield_s
{	float age;
	hfieldeffect effect;
	hfieldeffect nexteffect;
	int texnum;
	int width;	// width in squares
	int height;	// height in squares
	int spacing; // width of a square
	int numverts; // (width + 1) * (height + 1)
	int numfaces; // width * height
	vec3_t *verts;
	float *vdists;
	float *vsins;
	vec3_t *vnorms;
	tcoord_t *tcoords;
	vec3_t *vcolors;
	face_t *faces;
	vec3_t *fnorms;
} heightfield_t;

extern heightfield_t hfield;

int HField_Init(int width, int height, int spacing); // inits a flat heightfield
int HField_Destroy(void);
int HField_GenVerts(void);
int HField_GenDists(float scale);
int HField_GenSins(float scale);
int HField_GenFaces(void);
void HField_Settle(void); // settles the z-coords of the heightfield to zero
void HField_StartEffect(hfieldeffect effect);
void HField_InitEffect(hfieldeffect effect);
void HField_Animate(void);
void HField_AnimateSettle(void);
void HField_AnimateWavy1(void);
void HField_Draw(void);
void HField_GenVertColors(void);
void HField_GenFaceNormals(void);
void HField_GenVertNormals(void);
#endif