#ifndef _TEXTURES_H
#define _TEXTURES_H
#include <windows.h>
#include <stdio.h>
#include <GL/gl.h>
#include <GL/glu.h>

typedef GLubyte rgb3_t[3];
typedef GLubyte rgba_t[4];
typedef float rgbaf_t[4];
typedef float rgbf_t[4];


typedef struct tex_s
{	int width,
			height;
	int num;
	rgba_t *data;
} tex_t;

#pragma pack(push, 1)

typedef struct pcxhead_s
{
	char manufacturer;		/* always 10 */
	char ver;					/* 0 - Ver 2.5 Paintbrush
									 * 2 - Ver 2.8 with palette
									 * 3 - Ver 2.8 use default palette
									 * 5 - Ver 3.0 or better of Paintbrush */
	char encoding;				/* this is always 1, for RLE */
	char bits_per_pixel;		/* bits per pixel, usually 8 */
	short x1, y1;				/* upper left corner of image */
	short x2, y2;				/* lower right corner of image */
	short hor_res;				/* horizonal resolution (kinda useless) */
	short vert_res;			/* vertical resolution (kinda useless) */
									/* The content of these fields varies
										greatly from one file to the next. For
										example, Adobe photoshop saves the resolution
										in pixels/inch in the these fields while
										Quake screendumps have the video mode
										resolution. So, I'd just ignore these */
	char ega_palette[48];	/* EGA palette -- ignore :) */
	char reserved;				/* Who knows?  Set it zero to be safe. */
	char num_color_planes;	/* number of planes in the image (usually 1) */
	short bytes_per_line;	/* number of bytes in each scan line
										BEWARE: This will most likely be even
										even if the x2-x1+1 is odd */
	short palette_type;		/* eh, who cares? (usually 2) */
	char padding[58];			/* let's take up some space */
} pcxhead_t;

#pragma pack(pop)

int Load_Texture(char *filename, int texnum);
void MakeMips(tex_t *t);
void HalveTexture(tex_t *t);


#endif