#include "textures.h"

int Load_Texture(char *filename, int texnum)
{
	FILE *texfile;
	int i, data_size=0, data_read=0, num_bytes;
	int width, height;
	unsigned char in_data;
	unsigned char *buf;
	rgba_t *data;
	rgb3_t *palette;
	tex_t t;
	pcxhead_t head;

	if ( !(texfile = fopen(filename,"rb")) )
	{	return 0;
	}
	if ( !(palette = (rgb3_t*)malloc(256*sizeof(rgb3_t))) )
	{	return 0;
	}

	/* load header */
	if ( fread(&head, sizeof(pcxhead_t), 1, texfile) != 1 )
	{	free(palette);
		return 0;
	}

	width = head.x2 - head.x1 + 1;
	height = head.y2 - head.y1 + 1;
	data_size = width * height;

	if ( !(buf = (unsigned char*)malloc(data_size)) )
	{	free(palette);
		return 0;
	}

	/* Load palette */
	fseek(texfile,-768L,SEEK_END);
	for (i=0; i<256; i++)
	{	 palette[i][0]	= (fgetc(texfile)); //red
		 palette[i][1]	= (fgetc(texfile)); //green
		 palette[i][2]	= (fgetc(texfile)); //blue
	}

	/* load and decompress pixel data */
	fseek(texfile,128,SEEK_SET);
	while (data_read < data_size)
	{	in_data = getc(texfile);
		if ( (in_data>=192) && (in_data <=255) ) // run
		{	num_bytes = in_data - 192;
			in_data = getc(texfile);
			while(num_bytes-- >0) {	buf[data_read++]= in_data; } // replicate pixel
		}
		else buf[data_read++]= in_data; // single pixel
	}
	fclose(texfile);
	data=(rgba_t*)malloc(data_size*sizeof(rgba_t));
	for ( i=0; i<data_size; i++)
	{	if ( buf[i] == 255 ) // transparent
		{	data[i][0] = data[i][1] = data[i][2] = 255;
			data[i][3] = 0;
		}
		else
		{	
			data[i][0]=palette[buf[i]][0];
			data[i][1]=palette[buf[i]][1];
			data[i][2]=palette[buf[i]][2];
			data[i][3]=255;
		}
	}
	free(buf);
	free(palette);
	t.width = width;
	t.height = height;
	t.data = data;
	t.num = texnum;
	glBindTexture(GL_TEXTURE_2D, texnum);
#pragma warning(disable : 4244)
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_NEAREST);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
#pragma warning(default : 4244)
	// set all four mip levels with the same texture
	MakeMips(&t);
	glBindTexture(GL_TEXTURE_2D, 0);
	free(data);
	return 1;
}

void HalveTexture(tex_t *t)
{	int srow, trow, scol, tcol, w, h;

	w = t->width / 2;
	h = t->height / 2;
	for ( trow = 0, srow=0; srow < t->height; trow++, srow+=2 )
	{	for ( tcol = 0, scol = 0; scol < t->width; tcol++, scol+=2 )
		{	t->data[ trow * w + tcol ][0] = t->data[ srow * t->width + scol ][0];
			t->data[ trow * w + tcol ][1]=t->data[ srow * t->width + scol ][1];
			t->data[ trow * w + tcol ][2]=t->data[ srow * t->width + scol ][2];
			t->data[ trow * w + tcol ][3]=t->data[ srow * t->width + scol ][3];
		}
	}
	t->width = w;
	t->height = h;
}

void MakeMips(tex_t *t)
{	int i;
	
	glBindTexture(GL_TEXTURE_2D, t->num);
	glTexImage2D(GL_TEXTURE_2D, 0, 4, t->width, t->height, 0, GL_RGBA, GL_UNSIGNED_BYTE, t->data);
	for ( i=1; i<8; i++ )
	{	HalveTexture(t);
		glTexImage2D(GL_TEXTURE_2D, i, 4, t->width, t->height, 0, GL_RGBA, GL_UNSIGNED_BYTE, t->data);
	}
	glBindTexture(GL_TEXTURE_2D, 0);
}