#ifndef _PARTICLE_H
#define _PARTICLE_H

#include "mathlib.h"
#include "textures.h"

#define NUM_FOUNTAIN_PARTICLES 250
#define NUM_GRAVFIELD_PARTICLES 2000
#define PARTICLE_WIDTH 0.8
#define GRAVITY -200.0
#define PARTICLE_TEXTURE 3

#pragma pack(push, 1)


#ifndef NONE
#define NONE 0
#endif

#define FOUNTAIN 1
#define GRAVFIELD 2

extern float framedelta;

typedef int psystype;

typedef struct particle_s
{	vec3_t pos;
	vec3_t velocity;
	rgbaf_t color;
	float age; // <0 = dead.
} particle_t;

typedef struct psystem_s
{	struct psystem_s *next, *prev;
	int sysnum;
	psystype type;
	vec3_t pos;
	vec3_t velocity;
	float age;
	float gentime; // age at which it stops generating new particles, 0 = never
	float gendelta; // time between generating particles
	float nextgen;	// time to generate next particle
	int numparticles; // system dies when it has no more particles
	int maxparticles;
	particle_t **particles;	// array of pointers to particles
	char running;
} psystem_t;

extern psystem_t *psystems; // linked list of all systems
extern psystem_t *lastsys;

#pragma pack(pop)


int			Psys_New(psystype type);
					// creates a new system, tags it to the end of the list
					// and returns the new system's number
particle_t	*Psys_NewParticle(void);
void			Psys_CompactParticles(psystem_t *psys);
					// moves the particles to the front of the array
int			Psys_Init(psystem_t *psys);
					// initalizes a system
psystem_t	*Psys_SysForNum(int sysnum);
					// returns pointer to the particle system
					// with specified number.  NULL if it doesn't exist
int			Psys_RemoveN(int sysnum, int destroy);
					// removes a system from chain by number
int			Psys_RemoveP(psystem_t *psys, int destroy);
					// removes a system from chain by actual structure
void			Psys_AnimateAll(void);
void			Psys_AnimateFountain(psystem_t *psys);
void			Psys_AnimateGravfield(psystem_t *psys);
void			Psys_SortParticles(psystem_t *psys, int l, int r, int axis);
					// sorts particles for drawing.
void			Psys_DrawN(int sysnum);
void			Psys_DrawP(psystem_t *psys);
void			Psys_DrawAll(void);
void			Psys_SetPosN(int sysnum, float x, float y, float z);
void			Psys_SetPosP(psystem_t *sys, float x, float y, float z);

#endif