#include "feu.h"
#include "glib.h"

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <time.h>

#include <tlib.h>

#include <malloc.h>

#define NB_FEU 150
/* nombre de feux dans une fusee */

#define NB_FEUX_QUEUE 20
/* nombre de feux dans la queue */


#define NB_FUSEES_MAX 25

static texture tex;

static int chainages[NB_FUSEES_MAX];
/* chainage des fusees libres et des fusees en cours d'utilisation */

static int debut_libres;
static int debut_utilisees;

struct sfeu {
  MYREAL x[NB_FEU];
  MYREAL y[NB_FEU];
/*  MYREAL z[NB_FEU]; */
  MYREAL vx[NB_FEU];
  MYREAL vy[NB_FEU];
/*  MYREAL vz[NB_FEU]; */
  MYREAL r[NB_FEU];
  MYREAL g[NB_FEU];
  MYREAL b[NB_FEU];
  MYREAL a[NB_FEU];
  
  MYREAL m[NB_FEU];


/* parametres de queue */
  MYREAL Qx[NB_FEUX_QUEUE];
  MYREAL Qy[NB_FEUX_QUEUE];
/*  MYREAL Qz[NB_FEUX_QUEUE]; */
  MYREAL Qvx[NB_FEUX_QUEUE];
  MYREAL Qvy[NB_FEUX_QUEUE];
/*  MYREAL Qvz[NB_FEUX_QUEUE]; */
  MYREAL Qr[NB_FEUX_QUEUE];
  MYREAL Qg[NB_FEUX_QUEUE];
  MYREAL Qb[NB_FEUX_QUEUE];
  MYREAL Qa[NB_FEUX_QUEUE];
  
  MYREAL Qm[NB_FEUX_QUEUE];





  /* masse de chaque feu */
  
  MYREAL p; /* persistance */
  int etat; /* 0 avant explosion , 1 apres */
  MYREAL taille;

  MYREAL fact_augmente;
  MYREAL fact_diminue;
	
  int nb_feux;

  int flag;
  int dir;
  int num;

  int nbQ; /* nombre de feux dans la queue */
  
  MYREAL temps_explo; /* date de l'explosion */

  void (* explose)(feu);
  void (* affiche)(feu);
  void (* pas_queue)(feu,MYREAL);

};


static struct sfeu mes_feux[NB_FUSEES_MAX];


MYREAL rnd(void){
  return((MYREAL)((MYREAL)(rand())/32767 ));
}


void initFeu(int position){
  feu f;
  int i;
  MYREAL tmpx,tmpvx,tmpvy,tmpvz;
  MYREAL r,g,b;
  MYREAL tmpm;

  f = &mes_feux[position];
  
  tmpx = 200 + rnd() * 240;
  tmpvx = 3*(rnd() - 0.5);
  tmpvy = 6 + rnd() * 3;
  tmpvz = 0;

  tmpm = 0.1;

  r = 255 * rnd();
  g = 255 * rnd();
  b = 255 * rnd();

  if ( (r+g+b) < 300) {
	if (r < 100) r = r + 150;
	if (g < 100) g = g + 150;
	if (b < 100) b = b + 150;		
  }
  
  for (i = 0; i < NB_FEU; i++){
    f->x[i] = tmpx;
    f->y[i] = 0;
/*    f->z[i] = 0; */
      
    f->vx[i] = tmpvx;
    f->vy[i] = tmpvy;
/*    f->vz[i] = tmpvz; */
    
    f->m[i] = tmpm;
    
    f->r[i] = r;
    f->g[i] = g;
    f->b[i] = b;
    if (r>=g) { f->a[i] = r;}
    else { f->a[i] = g;}
    if (b>= f->a[i]) {f->a[i] = b;}
    
  }
 
  f->p = 1;
  f->etat = 0;
  f->taille = 10;
  f->flag =1;	

  f->nb_feux = NB_FEU;
  f->explose = explose1;
  f->pas_queue = NULL;
  f->affiche = tracefeu;
  

/*  f->fact_augmente = 1.01;
  f->fact_diminue = 0.98; */

  f->fact_augmente = 0.01/0.4;
  f->fact_diminue = 0.02/0.4; 

  f->nbQ = 0;

}



void initFeu2(int position){
  feu f;
  int i;
  MYREAL tmpx,tmpvx,tmpvy,tmpvz;
  MYREAL r,g,b,a;
  MYREAL r2,g2,b2,a2;
  MYREAL tmpm;
  MYREAL tmpm2;

  f = & mes_feux[position];
  
  tmpx = 200 + rnd() * 240;
  tmpvx = 3*(rnd() - 0.5);
  tmpvy = 6 + rnd() * 3;
  tmpvz = 0;

  tmpm = 0.1;
  tmpm2 = 0.3;

  r = 255 * rnd();
  g = 255 * rnd();
  b = 255 * rnd();
  a = 200;

  r2 = 255 * rnd();
  g2 = 255 * rnd();
  b2 = 255 * rnd();
  a2 = 200;


  if ( (r+g+b) < 300) {
	if (r < 100) r = r + 150;
	if (g < 100) g = g + 150;
	if (b < 100) b = b + 150;		
  }
  
  for (i = 0; i < NB_FEU; i++){
    f->x[i] = tmpx;
    f->y[i] = 0;
/*    f->z[i] = 0;  */
      
    f->vx[i] = tmpvx;
    f->vy[i] = tmpvy;
/*    f->vz[i] = tmpvz; */

	if ( i%2 == 0) { 

    f->m[i] = tmpm;
   
    f->r[i] = r;
    f->g[i] = g;
    f->b[i] = b;
    if (r>=g) { f->a[i] = r;}
    else { f->a[i] = g;}
    if (b>= f->a[i]) {f->a[i] = b;}
	}
	else {
		
    f->m[i] = tmpm;
   
    f->r[i] = r2;
    f->g[i] = g2;
    f->b[i] = b2;
    if (r2>=g2) { f->a[i] = r2;}
    else { f->a[i] = g2;}
    if (b2>= f->a[i]) {f->a[i] = b2;}

	}
  }
 
  f->flag =1;	
  f->p = 1;
  f->etat = 0;
  f->taille = 10;


  f->nb_feux = NB_FEU;
  f->explose = explose2;
  f->pas_queue = NULL;
  f->affiche = tracefeu;

  /*f->fact_augmente = 1.03;
  f->fact_diminue = 0.98;*/

  f->fact_augmente = 0.01/0.4;
  f->fact_diminue = 0.02/0.4; 

  f->nbQ = 0;

}



void initFeu3(int position){
  feu f;
  int i;
  MYREAL tmpx,tmpvx,tmpvy,tmpvz;
  MYREAL r,g,b,a;
  MYREAL r2,g2,b2,a2;
  MYREAL tmpm;
  MYREAL tmpm2;

  f = & mes_feux[position];
  
  tmpx = 200 + rnd() * 240;
  tmpvx = 3*(rnd() - 0.5);
  tmpvy = 6 + rnd() * 3;
  tmpvz = 0;

  tmpm = 0.1;
  tmpm2 = 0.3;

  r = 255 * rnd();
  g = 255 * rnd();
  b = 255 * rnd();
  a = 200;

  r2 = 255 * rnd();
  g2 = 255 * rnd();
  b2 = 255 * rnd();
  a2 = 200;


  if ( (r+g+b) < 300) {
	if (r < 100) r = r + 150;
	if (g < 100) g = g + 150;
	if (b < 100) b = b + 150;		
  }
  
  for (i = 0; i < NB_FEU; i++){
    f->x[i] = tmpx;
    f->y[i] = 0;
/*    f->z[i] = 0;  */
      
    f->vx[i] = tmpvx;
    f->vy[i] = tmpvy;
/*    f->vz[i] = tmpvz; */

	if ( i%2 == 0) { 

    f->m[i] = tmpm;
   
    f->r[i] = r;
    f->g[i] = g;
    f->b[i] = b;
    if (r>=g) { f->a[i] = r;}
    else { f->a[i] = g;}
    if (b>= f->a[i]) {f->a[i] = b;}
	}
	else {
		
    f->m[i] = tmpm;
   
    f->r[i] = r2;
    f->g[i] = g2;
    f->b[i] = b2;
    if (r2>=g2) { f->a[i] = r2;}
    else { f->a[i] = g2;}
    if (b2>= f->a[i]) {f->a[i] = b2;}

	}
  }

  f->nbQ = NB_FEUX_QUEUE;

for (i = 0; i < NB_FEUX_QUEUE; i++){
    f->Qx[i] = tmpx-tmpvx * 7.0 *(i+1) /NB_FEUX_QUEUE;
    f->Qy[i] = -tmpvy * 7.0 *(i+1) /NB_FEUX_QUEUE;
/*    f->Qz[i] = 0;  */
      
    f->Qvx[i] = tmpvx;
    f->Qvy[i] = tmpvy;
/*    f->Qvz[i] = tmpvz; */


    f->Qm[i] = tmpm;
   
    f->Qr[i] = 0.5*r*(MYREAL)(NB_FEUX_QUEUE - i)/NB_FEUX_QUEUE;
    f->Qg[i] = 0.5*g*(MYREAL)(NB_FEUX_QUEUE - i)/NB_FEUX_QUEUE;
    f->Qb[i] = 0.5*b*(MYREAL)(NB_FEUX_QUEUE - i)/NB_FEUX_QUEUE;
	f->Qa[i] = 0.5*f->a[i]*(MYREAL)(NB_FEUX_QUEUE - i)/NB_FEUX_QUEUE;

  }
 




  f->flag =1;	
  f->p = 1;
  f->etat = 0;
  f->taille = 10;


  f->nb_feux = NB_FEU;
  f->explose = explose2;
  f->pas_queue = pas_queue_2;
  f->affiche = tracefeuqueue2;

  /*f->fact_augmente = 1.03;
  f->fact_diminue = 0.98;*/

  f->fact_augmente = 0.01/0.4;
  f->fact_diminue = 0.02/0.4; 



}


void initFeu4(int position){
  feu f;
  int i;
  MYREAL tmpx,tmpvx,tmpvy,tmpvz;
  MYREAL r,g,b,a;
  MYREAL r2,g2,b2,a2;
  MYREAL tmpm;
  MYREAL tmpm2;

  f = & mes_feux[position];
  
  tmpx = 200 + rnd() * 240;
  tmpvx = 3*(rnd() - 0.5);
  tmpvy = 6 + rnd() * 3;
  tmpvz = 0;

  tmpm = 0.1;
  tmpm2 = 0.3;

  r = 255 * rnd();
  g = 255 * rnd();
  b = 255 * rnd();
  a = 200;

  r2 = 255 * rnd();
  g2 = 255 * rnd();
  b2 = 255 * rnd();
  a2 = 200;


  if ( (r+g+b) < 300) {
	if (r < 100) r = r + 150;
	if (g < 100) g = g + 150;
	if (b < 100) b = b + 150;		
  }
  
  for (i = 0; i < NB_FEU; i++){
    f->x[i] = tmpx;
    f->y[i] = 0;
/*    f->z[i] = 0;  */
      
    f->vx[i] = tmpvx;
    f->vy[i] = tmpvy;
/*    f->vz[i] = tmpvz; */

    f->m[i] = tmpm;
   
    f->r[i] = r;
    f->g[i] = g;
    f->b[i] = b;
    if (r>=g) { f->a[i] = r;}
    else { f->a[i] = g;}
    if (b>= f->a[i]) {f->a[i] = b;}
  }
  f->nbQ = NB_FEUX_QUEUE;

for (i = 0; i < NB_FEUX_QUEUE; i++){
    f->Qx[i] = tmpx-tmpvx * 7.0 *(i+1) /NB_FEUX_QUEUE;
    f->Qy[i] = -tmpvy * 7.0 *(i+1) /NB_FEUX_QUEUE;
/*    f->Qz[i] = 0;  */
      
    f->Qvx[i] = tmpvx;
    f->Qvy[i] = tmpvy;
/*    f->Qvz[i] = tmpvz; */


    f->Qm[i] = tmpm;
   
    f->Qr[i] = 0.5*r*(MYREAL)(NB_FEUX_QUEUE - i)/NB_FEUX_QUEUE;
    f->Qg[i] = 0.5*g*(MYREAL)(NB_FEUX_QUEUE - i)/NB_FEUX_QUEUE;
    f->Qb[i] = 0.5*b*(MYREAL)(NB_FEUX_QUEUE - i)/NB_FEUX_QUEUE;
	f->Qa[i] = 0.5*f->a[i]*(MYREAL)(NB_FEUX_QUEUE - i)/NB_FEUX_QUEUE;

  }
 




  f->flag =1;	
  f->p = 1;
  f->etat = 0;
  f->taille = 10;


  f->nb_feux = NB_FEU;
  f->explose = explose3;
  f->pas_queue = pas_queue_1;
  f->affiche = tracefeuqueue;

  /*f->fact_augmente = 1.03;
  f->fact_diminue = 0.98;*/

  f->fact_augmente = 0.01/0.4;
  f->fact_diminue = 0.02/0.4; 



}





void pas_queue_1(feu f, MYREAL dt){
int i;

for (i = 0; i < NB_FEUX_QUEUE ; i++){
//    f->Qx[i] += dt * f->Qvx[i];
//    f->Qy[i] += dt * f->Qvy[i];
/*    f->Qz[i] += dt * f->Svz[i]; */

//    f->Qvy[i] -= dt * f->Qm[i];

    f->Qx[i] = f->x[0]-f->vx[0] * 10.0 *(i+1) /NB_FEUX_QUEUE;
    f->Qy[i] = f->y[0]-f->vy[0] * 10.0 *(i+1) /NB_FEUX_QUEUE;
/*    f->Qz[i] = 0;  */
      
    f->Qvx[i] = f->vx[0];
    f->Qvy[i] = f->vy[0];
/*    f->Qvz[i] = tmpvz; */
	
}

}

void pas_queue_2(feu f, MYREAL dt){
int i;

for (i = 0; i < NB_FEUX_QUEUE ; i++){
//    f->Qx[i] += dt * f->Qvx[i];
//    f->Qy[i] += dt * f->Qvy[i];
/*    f->Qz[i] += dt * f->Svz[i]; */

//    f->Qvy[i] -= dt * f->Qm[i];

    f->Qx[i] = f->x[0]-f->vx[0] * 9.0 *(i+1) /NB_FEUX_QUEUE + f->vy[0] * cos(3.0*f->vy[0] + 9.0 *(i+1) /NB_FEUX_QUEUE);
    f->Qy[i] = f->y[0]-f->vy[0] * 9.0 *(i+1) /NB_FEUX_QUEUE - f->vx[0] * cos(3.0*f->vy[0] + 9.0 *(i+1) /NB_FEUX_QUEUE);
/*    f->Qz[i] = 0;  */
      
    f->Qvx[i] = f->vx[0];
    f->Qvy[i] = f->vy[0];
/*    f->Qvz[i] = tmpvz; */
	
}

}




void tracefeu(feu f){
  int i;

  sauveEtat3DFX();
  initflare(tex);
  
  i = 0;
  if (f->etat == 0){
       flare(f->x[i],f->y[i],f->taille,f->r[i],f->g[i],f->b[i],f->a[i]);
     }
  else {

  for (i = 0 ; i < f->nb_feux ; i++){ 
    flare(f->x[i],f->y[i],f->taille,f->r[i],f->g[i],f->b[i],f->a[i]);
   
  }

  }

  restoreEtat();

}



void tracefeuqueue(feu f){
  int i;

  sauveEtat3DFX();
  initflare(tex);
  
  i = 0;
  if (f->etat == 0){
       flare(f->x[i],f->y[i],f->taille,f->r[i],f->g[i],f->b[i],f->a[i]);
	   for (i = 0 ; i < f->nbQ ; i++){ 
			flare(f->Qx[i],f->Qy[i],f->taille,f->Qr[i],f->Qg[i],f->Qb[i],f->Qa[i]);
   		}		
  	}
  else {

  for (i = 0 ; i < f->nb_feux ; i++){ 
    flare(f->x[i],f->y[i],f->taille,f->r[i],f->g[i],f->b[i],f->a[i]);
   
  }

  }

  restoreEtat();

}


void tracefeuqueue2(feu f){
  int i;

  sauveEtat3DFX();
  initflare(tex);
  
  i = 0;
  if (f->etat == 0){
//       flare(f->x[i],f->y[i],f->taille,f->r[i],f->g[i],f->b[i],f->a[i]);
	   for (i = 0 ; i < f->nbQ ; i++){ 
			flare(f->Qx[i],f->Qy[i],f->taille,f->Qr[i],f->Qg[i],f->Qb[i],f->Qa[i]);
   		}		
  	}
  else {

  for (i = 0 ; i < f->nb_feux ; i++){ 
    flare(f->x[i],f->y[i],f->taille,f->r[i],f->g[i],f->b[i],f->a[i]);
   
  }

  }

  restoreEtat();

}




void pasFeu(feu f, MYREAL dt){
  int i;


  if (f->etat == 1){
  for (i = 0; i < f->nb_feux; i++){
    
    f->x[i] += dt * f->vx[i];
    f->y[i] += dt * f->vy[i];
/*    f->z[i] += dt * f->vz[i]; */

    f->vy[i] -= dt * f->m[i];
    
    if (f->etat ==1){

		if (f->dir ==1){
			/*f->a[i] = f->a[i] * f->fact_augmente;*/
			f->a[i] *= 1.0 + dt * f->fact_augmente;
			if (f->a[i] < 255) {
				/*f->r[i] = f->r[i] * f->fact_augmente;
				f->g[i] = f->g[i] * f->fact_augmente;
				f->b[i] = f->b[i] * f->fact_augmente;*/
				f->r[i] *= 1.0 + dt * f->fact_augmente;
				f->g[i] *= 1.0 + dt * f->fact_augmente;
				f->b[i] *= 1.0 + dt * f->fact_augmente;
			}
		else {
				f->a[i] = f->a[i] - dt * f->fact_augmente;
				f->dir = -1;
			}
		}
		else {
			/*f->a[i] *= f->fact_diminue;*/
			f->a[i] *= 1.0 - dt*f->fact_diminue;

			if (f->a[i] > 10.0) {
				/* f->r[i] *= f->fact_diminue;
				f->g[i] *= f->fact_diminue;
				f->b[i] *= f->fact_diminue; */

				f->r[i] *= 1.0 - dt*f->fact_diminue;
				f->g[i] *= 1.0 - dt*f->fact_diminue;
				f->b[i] *= 1.0 - dt*f->fact_diminue;
			}
			else {
				f->etat = 2; /* c'est la fin ... */
			}
		}
    }    
  }

 	if (f->flag == 1) {
		f->taille = f->taille + dt * 1.5;
		if (f->taille > 18) {f->flag =0;}
	}
	else {
		f->taille = f->taille - dt * 0.2;	
		if (f->taille < 1) {f->etat = 2;}
	}
  }
  
  else {
  if (f->etat == 0){
    if (f->vy[0] < 0) {
/*    	if (nombre_fusees ==0){
			nombre_fusees = 1;*/
			f->explose(f);      
/*    	}*/
    }
  for (i = 0; i < f->nb_feux; i++){
    
    f->x[i] += dt * f->vx[i];
    f->y[i] += dt * f->vy[i];
/*    f->z[i] += dt * f->vz[i]; */

    f->vy[i] -= dt * f->m[i];    
  }
  if (f->nbQ > 0) f->pas_queue(f,dt);
 }
 }
}

void explose1(feu f){
	MYREAL tai;
	MYREAL xx,yy,zz;
	int i;
	MYREAL tmp;

   f->etat = 1; /* on met l'etat a 1 c'est a dire qu'on a explose */
   f->taille = 3;
   f->dir = 1;

   for (i = 0; i< f->nb_feux; i++){

	tai = rnd() * 4;

	f->x[i] += tai * f->vx[i];
	f->y[i] += tai * f->vy[i];
/*	f->z[i] += tai * f->vz[i]; */

	xx =rnd() - 0.5;
	yy =rnd() - 0.4;
	zz =rnd() - 0.5;

	tmp = 5 * ((rnd() + 0.2)*(1 - 2*f->m[i])) / (sqrt(xx*xx+yy*yy+zz*zz) + 0.001) ;
	
	f->vx[i] += tmp* xx;
	f->vy[i] += tmp* yy;
/*	f->vz[i] += tmp* zz; */

   } 
}


void explose2(feu f){
	MYREAL xx,yy,zz;
	int i;
	MYREAL tmp;

   f->etat = 1; /* on met l'etat a 1 c'est a dire qu'on a explose */
   f->taille = 3;
   f->dir = 1;

   for (i = 0; i< f->nb_feux; i++){

    xx =rnd() - 0.5;
	yy =rnd() - 0.5;
	zz =rnd() - 0.5;

	tmp = 5 * (1-2*f->m[i]) / (sqrt(xx*xx+yy*yy+zz*zz) + 0.001) ;
	
	f->vx[i] += tmp * xx ;
	f->vy[i] += tmp* yy ;
/* 	f->vz[i] += tmp* zz ;*/

   } 
}



void explose3(feu f){
	MYREAL tai;
	MYREAL xx,yy,zz;
	MYREAL xx2,yy2,zz2;
	int i;
	MYREAL tmp;
	MYREAL tmp2;
	int j;

   f->etat = 1; /* on met l'etat a 1 c'est a dire qu'on a explose */
   f->taille = 3;
   f->dir = 1;

   f->nb_feux = (int)(f->nb_feux / 10) *10;

   for (i = 0; i< (int)(f->nb_feux / 10); i++){

	tai = 4.0*rnd();

	xx =rnd() - 0.5;
	yy =rnd() - 0.4;
	zz =rnd() - 0.5;

	tmp = 5 * (1-2*f->m[i]) / (sqrt(xx*xx+yy*yy+zz*zz) + 0.001) ;

	for (j = 0; j < 15; j++){
		xx2 =rnd() - 0.5;
		yy2 =rnd() - 0.4;
		zz2 =rnd() - 0.5;

		
		tmp2 = 0.9 * (1-2*f->m[i]) / (sqrt(xx*xx+yy*yy+zz*zz) + 0.001) ;
//		f->x[6*i+j] += tai * f->vx[i] ;
//		f->y[6*i+j] += tai * f->vy[i] ;
	/*	f->z[6*i+j] += tai * f->vz[i] * (MYREAL)(j+6)/6; */

		f->vx[i*15+j] += tmp* xx + tmp2 * xx2;
		f->vy[i*15+j] += tmp* yy + tmp2 * yy2;
/*	f->vz[i*6+j] += tmp* zz; */
	}
   } 
}



int pasFeux(MYREAL dt){
  int i,j;
  int nbfeux_actifs;

  i = debut_utilisees;
  j = i;

  nbfeux_actifs = 0;
  while (i >= 0){
	if (mes_feux[i].etat == 2){
		if (i == debut_utilisees) {
			debut_utilisees = chainages[i];
			}
		chainages[j] = chainages[i];		
		
		chainages[i] = debut_libres;
		debut_libres = i;
		i = chainages[j];
	}
  	else{
    	nbfeux_actifs ++;
		pasFeu(& mes_feux[i],dt);
		mes_feux[i].affiche(& mes_feux[i]);   		
	  	j = i;
  		i = chainages[i];
  	}
  }

	return(nbfeux_actifs);

}



void  addFeu ( int typefeu){
	int pos;
	
	pos = debut_libres;
	if (pos >=0){
		debut_libres = chainages[pos];
		chainages[pos] = debut_utilisees;
		debut_utilisees = pos;
		
		if (typefeu ==1) {
			initFeu(pos);	
		}
		else if (typefeu ==2){
			initFeu2(pos);			
		}
		else if (typefeu ==3){
			initFeu3(pos);			
		}
		else if (typefeu ==4){
			initFeu4(pos);			
		}
	}
}



void initFeux(void){
int i;

debut_utilisees = -1;
debut_libres = 0;
/* nombre_fusees = 0; */

for (i = 0;i < NB_FUSEES_MAX - 1 ; i++){
	chainages[i] = i+1;
}
	chainages[NB_FUSEES_MAX - 1] = -1;
}


void initTexture(void){

  tex = loadtexture("flare3.3df");
  
}


void
go_firework_keypressed( void )
{
  MYREAL dt; /* time elapsed since last refresh of the screen */
  MYREAL deltaT; /* time elapsed since the throwing of the last rocket*/
  
  unsigned int deb_h,deb_b;
  unsigned int fin_h,fin_b;
  MYREAL diff;


  initMethodes();

  initTexture();
 
  initFeux();
  
  addFeu(1);
  addFeu(2);
  addFeu(1);

 grBufferSwap( 1 );

  _asm _emit 0x0F
  _asm _emit 0x31
  _asm push eax
  _asm push edx
  _asm mov deb_h,eax
  _asm mov deb_b,edx
  _asm pop edx
  _asm pop eax
	
 grBufferSwap( 1 ); /* on est cense avoir attendu 1/60 secondes */

  _asm _emit 0x0F
  _asm _emit 0x31
  _asm push eax
  _asm push edx
  _asm mov fin_h,eax
  _asm mov fin_b,edx
  _asm pop edx
  _asm pop eax

  diff = (MYREAL)((fin_h - deb_h)) * 17000.0;

  deltaT = 0.0;

  while ( 1 ) {
    
	deb_b = fin_b;
	deb_h = fin_h;

     grBufferClear( 0x00000000, 0, GR_WDEPTHVALUE_FARTHEST );  
	 
	_asm _emit 0x0F
	_asm _emit 0x31
	_asm push eax
	_asm push edx
	_asm mov fin_h,eax
	_asm mov fin_b,edx
	_asm pop edx
	_asm pop eax
	
	dt = (MYREAL)(( fin_h - deb_h )) / diff ;
    
	pasFeux(dt); 
    
	
     if (rnd()*deltaT > 9.0){
		deltaT = 0.0;
		addFeu((int)(1.0+rnd()*4));
     }
	 else {
		deltaT += dt;
	 }
  
     grBufferSwap( 1 );
     if (tlKbHit ()) break;
  }

 deleteAllFeux();


}




void
go_firework_forNseconds( int n )
{
  int nbsec;
  int nb_actifs;

  MYREAL dt; /* time elapsed since last refresh of the screen */
  MYREAL deltaT; /* time elapsed since the throwing of the last rocket*/
  
  unsigned int deb_h,deb_b;
  unsigned int fin_h,fin_b;
  MYREAL diff;

  initMethodes();

  initTexture();
 
  initFeux();
  
  addFeu(1);
  addFeu(2);
  addFeu(1);

 grBufferSwap( 1 );

  _asm _emit 0x0F
  _asm _emit 0x31
  _asm push eax
  _asm push edx
  _asm mov deb_h,eax
  _asm mov deb_b,edx
  _asm pop edx
  _asm pop eax
	
 grBufferSwap( 1 ); /* on est cense avoir attendu 1/60 secondes */

  _asm _emit 0x0F
  _asm _emit 0x31
  _asm push eax
  _asm push edx
  _asm mov fin_h,eax
  _asm mov fin_b,edx
  _asm pop edx
  _asm pop eax

  diff = (MYREAL)((fin_h - deb_h)) * 17000.0;

  deltaT = 0.0;

  for (nbsec=1; nbsec < n*60 ; nbsec++  ) {
    
	deb_b = fin_b;
	deb_h = fin_h;

     grBufferClear( 0x00000000, 0, GR_WDEPTHVALUE_FARTHEST );  
	 
	_asm _emit 0x0F
	_asm _emit 0x31
	_asm push eax
	_asm push edx
	_asm mov fin_h,eax
	_asm mov fin_b,edx
	_asm pop edx
	_asm pop eax
	
	dt = (MYREAL)(( fin_h - deb_h )) / diff ;
    
	pasFeux(dt); 
    
	
     if (rnd()*deltaT > 9.0){
		deltaT = 0.0;
		if (rnd() > 0.5){
       addFeu(1);
		}
		else {
		 addFeu(2);
		}
     }
	 else {
		deltaT += dt;
	 }
  
     grBufferSwap( 1 );
  }


  nb_actifs=1;

  while (nb_actifs > 0){
	deb_b = fin_b;
	deb_h = fin_h;

     grBufferClear( 0x00000000, 0, GR_WDEPTHVALUE_FARTHEST );  
	 
	_asm _emit 0x0F
	_asm _emit 0x31
	_asm push eax
	_asm push edx
	_asm mov fin_h,eax
	_asm mov fin_b,edx
	_asm pop edx
	_asm pop eax
	
	dt = (MYREAL)(( fin_h - deb_h )) / diff ;
    
	nb_actifs = pasFeux(dt); 
    
	grBufferSwap( 1 );
  }

}







void deleteAllFeux(void){
  int i,j;
  
  i = debut_utilisees;
  j = i;

  while (i >= 0){
	if (i == debut_utilisees) {
			debut_utilisees = chainages[i];
			}
		chainages[j] = chainages[i];		
		
		chainages[i] = debut_libres;
		debut_libres = i;
		i = chainages[j];
	  	j = i;
  		i = chainages[i];
  }

}