/*
 * Asteroid Flight ScreenSaver
 *  Copyright (c) 1998 Tauno Taipaleenmki <tataipal@mail.student.oulu.fi>,
 *  All rights reserved.
 *
 *         FILE : TEXTURES.CPP
 *      PURPOSE : Texture Management
 *      VERSION : 1.00
 * LAST CHANGED : 28/02/1998
 *
 * NOTES:
 * All the loaded textures are assumed to be 8bpp with a palette. No
 * error checking is performed.
 *
 */

//
// Set the active texture & download the correct palette
//
void Set_Active_Texture(int index)
{
    if (texture_data[index].texinfo.format == GR_TEXFMT_P_8)
        grTexDownloadTable(GR_TMU0, GR_TEXTABLE_PALETTE, &texture_data[index].fileinfo.table.palette );
    grTexSource( GR_TMU0, texture_data[index].addr, GR_MIPMAPLEVELMASK_BOTH, 
                    &texture_data[index].texinfo );
}

//
// Get starting address for a given mipmap (from GLIDEPGM.DOC)
//
#define TEXMEM_2MB_EDGE 2097152
FxU32 textureSize, nextTexture, lastTexture;

long getStartAddress(FxU32 evenOdd, GrTexInfo *info)
{	long start;
	textureSize = grTexTextureMemRequired(evenOdd, info); 
	start = nextTexture;

	/* check for 2MB edge and space past it if necessary */
	if ((start< TEXMEM_2MB_EDGE) && (start+textureSize> TEXMEM_2MB_EDGE))
		start = TEXMEM_2MB_EDGE;

	nextTexture += textureSize;
	if (nextTexture <= lastTexture) return start;
	else {
		nextTexture = start;
		return -1;
	}
}

//
// Load a .3df texturemap
//
void Load_Texture(char *filename)
{
static int  init = 0;

    if (init == 0) {            // First texture, Initialize variables
        nextTexture = grTexMinAddress(GR_TMU0); 
        lastTexture = grTexMaxAddress(GR_TMU0);
        init++;
    }

    gu3dfGetInfo(filename, &texture_data[num_textures].fileinfo);
    texture_data[num_textures].fileinfo.data = malloc( texture_data[num_textures].fileinfo.mem_required );
    gu3dfLoad(filename, &texture_data[num_textures].fileinfo);

// Fill in guTexInfo structure for later use
    texture_data[num_textures].texinfo.format       = texture_data[num_textures].fileinfo.header.format;
    texture_data[num_textures].texinfo.aspectRatio  = texture_data[num_textures].fileinfo.header.aspect_ratio;
    texture_data[num_textures].texinfo.largeLod     = texture_data[num_textures].fileinfo.header.large_lod;
    texture_data[num_textures].texinfo.smallLod     = texture_data[num_textures].fileinfo.header.small_lod;
    texture_data[num_textures].texinfo.data         = texture_data[num_textures].fileinfo.data;

// Load texture to TMU
    texture_data[num_textures].addr = getStartAddress( GR_MIPMAPLEVELMASK_BOTH, &texture_data[num_textures].texinfo );
    grTexDownloadMipMap( GR_TMU0, texture_data[num_textures].addr,
                        GR_MIPMAPLEVELMASK_BOTH, &texture_data[num_textures].texinfo );
    num_textures++;
}

