/*
 * TTT's Modern Dreams - Screensaver
 *  Copyright (c) 1998 Tauno Taipaleenmki <tataipal@mail.student.oulu.fi>,
 *  All rights reserved.
 *
 *         FILE : REGISTRY.CPP
 *      PURPOSE : Loading & Saving of settings from the registry
 *      VERSION : 1.00
 * LAST CHANGED : 3/03/1998
 *
 * NOTES: -
 *
 */

///////////////////////////////////////////////////////////////////////////////
///																																					///
/// REGISTRY HANDLING FUNCTIONS																							///
///																																					///
/// STORING:																																///
/// Reg_Add_String(char *, char *)																					///
/// Reg_Add_Long(char *,long)																								///
///																																					///
/// RETRIEVING:																															///
/// Reg_Get_Value(char *, char *, long *type, long *len)										///
///																																				  ///
///////////////////////////////////////////////////////////////////////////////
int Reg_Add_String(char *key, char *value)
{
    return( RegSetValueEx( SaverKey, key, 0,REG_SZ,(const unsigned char *)value, (strlen(value)+1) ) );
}

int Reg_Add_Long(char *key, ulong value)
{
    return( RegSetValueEx( SaverKey, key, 0, REG_DWORD, (const unsigned char *)&value, 4 ) );
}

int Reg_Get_Value(char *key, char *buffer, unsigned long *type, unsigned long len)
{
    return( RegQueryValueEx( SaverKey, key, 0, type, (unsigned char *)buffer, &len ) );
}

//
// Generate the key-entries under Software\TTT Productions\Modern Dreams
//
void Default_Settings(void)
{
    char                buf[ 4096 ];
    int                 status=0;

    if (!GetSystemDirectory( buf, 4096 )) {
        FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, status,
                LANG_NEUTRAL, (LPSTR)buf, 4095, NULL );
        MessageBox( NULL, buf, "TTT's Modern Dreams - Screensaver", MB_OK | MB_APPLMODAL );
        return;
    }
    strcpy(data_directory, buf);
    Reg_Add_String(    "Data directory", buf);
    Reg_Add_Long("Maximum resolution", 0 );
    maximum_resolution = 1;
}

//
// Save the new settings back to registry
//
void Save_Settings(void)
{
    int             status;
    ulong           style;
    char            buf[ 2048 ];

	status = RegCreateKeyEx( HKEY_LOCAL_MACHINE, 
                             REGISTRY_KEY,
                                0,
                                "Modern Dreams",
                                REG_OPTION_NON_VOLATILE,
                                KEY_ALL_ACCESS,
                                NULL,
                                &SaverKey,
                                &style );

	if (status != ERROR_SUCCESS) {				// Cannot create registry key !
		FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, status,
				LANG_NEUTRAL, (LPSTR)&buf[0], 2047, NULL );
        MessageBox( NULL, buf, "TTT's Modern Dreams - Screensaver", MB_OK );
        return;
    }

    Reg_Add_String(     "Data directory", data_directory );
    Reg_Add_Long( "Maximum resolution", maximum_resolution );
    RegCloseKey( SaverKey );
}

//
// Load settings from registry
//
void Load_Settings(void)
{
    int             status;
    ulong           style;
    char            buf[ 2048 ];
    HKEY            akey;

    status = RegCreateKeyEx( HKEY_LOCAL_MACHINE, COMPANY_KEY, 0, "TTT Productions",
							REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &akey, &style );
	RegCloseKey( akey );

/// Create / Open the main zeditor registry key
	status = RegCreateKeyEx( HKEY_LOCAL_MACHINE, 
                            REGISTRY_KEY,
							0,
                            "Modern Dreams",
							REG_OPTION_NON_VOLATILE, 
							KEY_ALL_ACCESS, 
							NULL, 
                            &SaverKey,
							&style );

	if (status != ERROR_SUCCESS) {				// Cannot create registry key !
		FormatMessage( FORMAT_MESSAGE_FROM_SYSTEM, NULL, status,
				LANG_NEUTRAL, (LPSTR)&buf[0], 2047, NULL );
        MessageBox( NULL, buf, "TTT's Modern Dreams - ScreenSaver", MB_OK | MB_APPLMODAL );
        return;
    }

// If the key didn't exists, create the default settings
    if (style == REG_CREATED_NEW_KEY) {
        Default_Settings();
	} else {
        Reg_Get_Value(     "Data directory",  data_directory, NULL, sizeof(data_directory) );
        Reg_Get_Value( "Maximum resolution", (char *)&maximum_resolution, NULL, 4 );
	}

    RegCloseKey( SaverKey );
}
