/*
 * TTT's Modern Dreams - Screensaver
 *	Copyright (c) 1998 Tauno Taipaleenmki <tataipal@mail.student.oulu.fi>,
 *	All rights reserved.
 *
 *         FILE : PALETTE.CPP
 *      PURPOSE : Simple palette fading in/out
 *		VERSION : 1.00
 * LAST CHANGED : 3/03/1998
 *
 * NOTES: Assumes RGBA order.
 *
 */

//
// Fade source down to match target
//
int FadeDownTo(GuTexPalette *source, GuTexPalette *target)
{
    int             i,ready=1;
    ulong           sr,sg,sb,dr,dg,db;

    for(i=0;i<256;i++) {
        if (source->data[i] != target->data[i]) {  // Check if already the same
            ready = 0;
            sr = (source->data[i] >> 16) & 255;
            sg = (source->data[i] >> 8) & 255;
            sb = (source->data[i]) & 255;

            dr = (target->data[i] >> 16) & 255;
            dg = (target->data[i] >> 8) & 255;
            db = (target->data[i]) & 255;

            if (sr > dr) {
                sr -= 5;
                if (sr < dr)
                    sr = dr;
            }
            if (sg > dg) {
                sg -= 5;
                if (sg < dg)
                    sg = dg;
            }
            if (sb > db) {
                sb -= 5;
                if (sb < db)
                    sb = db;
            }
            source->data[i] = (sr << 16) | (sg << 8) | sb;
         }
    }

    return ready;
}




//
// Fade source palette up to match target
//
int FadeInTo(GuTexPalette *source, GuTexPalette *target)
{
    int             i,ready=1;
    ulong           sr,sg,sb,dr,dg,db;


    for(i=0;i<256;i++) {
        if (source->data[i] != target->data[i]) {  // Check if already the same
            ready = 0;
            sr = (source->data[i] >> 16) & 255;
            sg = (source->data[i] >> 8) & 255;
            sb = (source->data[i]) & 255;

            dr = (target->data[i] >> 16) & 255;
            dg = (target->data[i] >> 8) & 255;
            db = (target->data[i]) & 255;

            if (sr < dr) sr++;
            if (sg < dg) sg++;
            if (sb < db) sb++;

            source->data[i] = (sr << 16) | (sg << 8) | sb;
         }
    }

    return ready;
}

//
// Fade source palette out to total darkness
//
int FadeOutToBlack(GuTexPalette *source)
{
    int             i,ready=1;
    slong           sr,sg,sb,dr,dg,db;


    for(i=0;i<256;i++) {
        if (source->data[i] != 0) {  // Check if already the same
            ready = 0;
            sr = (source->data[i] >> 16) & 255;
            sg = (source->data[i] >> 8) & 255;
            sb = (source->data[i] ) & 255;


            if (sr > 0) {
                sr -= 2;
                if (sr < 0)
                    sr = 0;
            }
            if (sg > 0) {
                sg -= 2;
                if (sg < 0)
                    sg = 0;
            }
            if (sb > 0) {
                sb -= 2;
                if (sb < 0)
                    sb = 0;
            }

            source->data[i] = (sr << 16) | (sg << 8) | sb;
         }
    }

    return ready;
}

//
// Fade source palette into white
//
int FadeToWhite(GuTexPalette *source)
{
    int             i,ready=1;
    slong           sr,sg,sb,dr,dg,db;


    for(i=0;i<256;i++) {
        if (source->data[i] != 0xFFFFFF) {  // Check if already the same
            ready = 0;
            sr = (source->data[i] >> 16) & 255;
            sg = (source->data[i] >> 8) & 255;
            sb = (source->data[i]) & 255;

            if (sr < 255) {
                sr += 6;
                if (sr > 255)
                    sr = 255;
            }
            if (sg < 255) {
                sg += 6;
                if (sg > 255)
                    sg = 255;
            }
            if (sb < 255) {
                sb += 6;
                if (sb > 255)
                    sb = 255;
            }
            source->data[i] = (sr << 16) | (sg << 8) | sb;
         }
    }

    return ready;
}


