/*
 * TTT's Modern Dreams - Screensaver
 *  Copyright (c) 1998 Tauno Taipaleenmki.
 *
 * This is my entry to the Operation: 3.D.F.X. Screen Saver competition.
 *
 * This program and its source code maybe freely distributed.
 *
 * NOTES:
 *
 * This program is based on the SKELETON.C in the Microsoft Visual C++ 5.0
 * distribution package. The file can be found under the
 * SAMPLES\SDK\SDKTOOLS\SCRNSAVE directory.
 *
 * Compiled under Microsoft Visual C++ 5.0.
 */

#define __MSC__
#include <windows.h>
#include <glide.h>
#include <stdio.h>
#include <float.h>
#include <time.h>
#include <math.h>
#include <malloc.h>
#include "resource.h"
#include "saver.h"                  // Structure definitions
#include "space.h"                  // This is the "background" object

#define COMPANY_KEY         "Software\\TTT Productions"
#define REGISTRY_KEY        "Software\\TTT Productions\\Modern Dreams"

///////////////////////////////////////////////////////////////////////
///                                                                 ///
/// GLOBAL VARIABLES                                                ///
///                                                                 ///
///////////////////////////////////////////////////////////////////////
HINSTANCE               hInst;
HWND                    hMainWindow;
GrHwConfiguration       hwconfig;
texmap                  texture_data[10];
int                     num_textures=0,
                        current_frame=0,
                        NUM_POLYGONS=0,
                        NUM_VERTICES=0;
ulong                   maximum_resolution=0;
GrVertex                space_final[space_verts],
                        *final_vertices = NULL;
polygon                 *face_list = NULL;
vertex                  *vertex_list = NULL;

char                    data_directory[ 4096 ];


#define NUM_TEXTURES    7

        char            *texture_names[NUM_TEXTURES]={
                           { "texture0.3df" },
                           { "texture1.3df" },
                           { "texture2.3df" },
                           { "texture3.3df" },
                           { "texture4.3df" },
                           { "texture5.3df" },
                           { "texture6.3df" },
                        };

#define NUM_OBJECTS     4

        char            *object_names[NUM_OBJECTS]= {
                            { "object0.ttt" },
                            { "object1.ttt" },
                            { "object2.ttt" },
                            { "object3.ttt" },
                        };

vertex                  SpaceOrientation={0.0,0.0,0.0, 0.0, 0.0, 0.0 };
vertex                  ObjectOrientation={0.0,0.0,0.0, 0.0, 0.0, 0.0 };
float                   Depth = 1500.0,xspeed,yspeed,zspeed;
matrix                  ObjectMatrix;
matrix                  SpaceMatrix;
GuTexPalette            mypalette;
HKEY                    SaverKey;

#include "textures.cpp"             // Texture management routines
#include "3d.cpp"                   // 3D routines
#include "load.cpp"                 // Loading functions
#include "palette.cpp"              // Palette functions
#include "registry.cpp"             // Loading & Saving of settings

///////////////////////////////////////////////////////////////////////
///                                                                 ///
/// FUNCTION PROTOTYPES                                             ///
///                                                                 ///
///////////////////////////////////////////////////////////////////////
LRESULT CALLBACK ScreenSaverProc(HWND,UINT,WPARAM,LPARAM);

///////////////////////////////////////////////////////////////////////
///                                                                 ///
/// Set FPU precision to 24 bits                                    ///
///                                                                 ///
///////////////////////////////////////////////////////////////////////
void SetFPU(void) 
{
    long       memvar;

    _asm {
        finit		        ; initialize the FPU
        fwait		        ; wait for operation to complete
        fstcw [memvar]		; store FPU control word to memvar
        fwait		        ; wait for operation to complete
        mov eax, [memvar]	; move memvar to a register
        and eax, 0fffffcffh	; mask off precision bits to set to 24-bit precision
        mov [memvar], eax	; save control word to memory
        fldcw [memvar]		; load control word back to FPU
        fwait		        ; wait for operation to complete
    }
}


#define PI              3.141592654
#define HALFPI          PI/2.0
#define TWOPI           2.0 * PI

//
// Calculate spherical mapping coordinates for the "space"-object
//
void xyztohp(float x,float y,float z,float *h,float *p)
{
    if (x == 0.0 && z == 0.0) {
        *h = 0.0;
        if (y != 0.0)
            *p = (y < 0.0) ? -HALFPI : HALFPI;
        else
            *p = 0.0;
    }
    else {
        if (z == 0.0)
            *h = (x < 0.0) ? HALFPI : -HALFPI;
        else if (z < 0.0)
            *h = -atan(x / z) + PI;
        else
            *h = -atan(x / z);
        x = sqrt(x * x + z * z);
        if (x == 0.0)
            *p = (y < 0.0) ? -HALFPI : HALFPI;
        else
            *p = atan(y / x);
    }
}


///////////////////////////////////////////////////////////////////////
///                                                                 ///
/// INITIALIZATION                                                  ///
///                                                                 ///
///////////////////////////////////////////////////////////////////////
void Init(void)
{
    int         i;
    float       lon,lat,u,v,x,y,z;

    for(i=0;i<256;i++) {
        mypalette.data[i] = 0;
    }

    for(i=0;i<space_verts;i++) {
        space_vertices[i][0] *= 10.0;
        space_vertices[i][1] *= 10.0;
        space_vertices[i][2] *= 10.0;

        x = space_vertices[i][0];
        y = space_vertices[i][1];
        z = space_vertices[i][2];

        xyztohp(-x,y,z,&lon,&lat);
        lon = 1.0 - lon / TWOPI;
        lat = .5 - lat / PI;

        u = lon - floor(lon);
        v = lat - floor(lat);

        space_uv[i][0] = u * 255.0;
        space_uv[i][1] = v * 255.0;
    }
    xspeed = (float)(rand() % 7) / 2.5;
    yspeed = (float)(rand() % 7) / 2.5;
    zspeed = (float)(rand() % 7) / 2.5;

}

///////////////////////////////////////////////////////////////////////
///                                                                 ///
/// CONFIGURATION DIALOG                                            ///
///                                                                 ///
///////////////////////////////////////////////////////////////////////
BOOL FAR PASCAL ScreenSaverConfigureDialog( HWND hwnd, unsigned msg, UINT wparam, LONG lparam )
{
    int         rc;

    switch( msg ) {
        case WM_INITDIALOG:
            SetDlgItemText( hwnd, IDC_EDIT1, data_directory );
            if (maximum_resolution == 0)
                SendDlgItemMessage( hwnd, IDC_CHECK1, BM_SETCHECK, (WPARAM)BST_UNCHECKED, 0L );
            else
                SendDlgItemMessage( hwnd, IDC_CHECK1, BM_SETCHECK, (WPARAM)BST_CHECKED, 0L );
            return TRUE;
        case WM_COMMAND:
            if ( LOWORD( wparam ) == IDOK ) {
                rc = SendDlgItemMessage( hwnd, IDC_CHECK1, BM_GETCHECK, (WPARAM)0, 0L);
                if (rc == BST_CHECKED)
                    maximum_resolution = 1;
                else
                    maximum_resolution = 0;
                GetDlgItemText( hwnd, IDC_EDIT1, data_directory, 4095 );
                Save_Settings();
                EndDialog( hwnd, TRUE );
                return TRUE;
            } else if ( LOWORD( wparam ) == IDCANCEL ) {
                EndDialog( hwnd, TRUE );
                return TRUE;
            }
            break;
    }

    return FALSE;
};

///////////////////////////////////////////////////////////////////////
///                                                                 ///
/// WINDOWS MAIN FUNCTION                                           ///
///                                                                 ///
///////////////////////////////////////////////////////////////////////
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR szCmdLine, int nCmdShow)
{
    WNDCLASS            cls;
    int                 dx,dy,quit=0,i=0,step, curtex,rotate_space=0,newtex,
                        curobj,newobj;
    MSG                 msg;
static BOOL             here = FALSE;
static POINT            ptLast;
    POINT               ptCursor, ptCheck;
    float               x,y;
    char                system_path[4096], buf[4096];
    DWORD               start_time, elapsed;

/// Load settings from registry
    if (!GetSystemDirectory(data_directory, 4096)) {
        MessageBox( NULL, " ERROR: Cannot find your Windows system directory. Something is very wrong?", "TTT's Modern Dreams - Screensaver", MB_OK | MB_APPLMODAL );
    }
    Load_Settings();
    hInst = GetModuleHandle(NULL);
    srand( (unsigned)time( NULL ) );

// No command line parameters, run configuration dialog.
    if (!szCmdLine) {
        DialogBox( hInst, MAKEINTRESOURCE(DLG_SCRNSAVECONFIGURE), NULL, (DLGPROC)ScreenSaverConfigureDialog );
        return 1;
    } else {
        szCmdLine++;            // Skip either / or -
        if ((!szCmdLine) || (*szCmdLine == TEXT('c')) || (*szCmdLine == TEXT('C'))) {
            DialogBox( hInst, MAKEINTRESOURCE(DLG_SCRNSAVECONFIGURE), NULL, (DLGPROC)ScreenSaverConfigureDialog );
            return 1;
        }
// No preview available (Maybe it should be available for RUSH owners?)
        if ((*szCmdLine == TEXT('p')) || (*szCmdLine == TEXT('P')) || (*szCmdLine == TEXT('w')) || (*szCmdLine == TEXT('W'))) {
            return 1;
        }
    }

// If we are already running, let's not run twice
    if (hPrevInstance != NULL) return FALSE;

//  Register a class for the main application window
    cls.hCursor        = NULL;
    cls.hIcon          = LoadIcon (hInst, MAKEINTATOM (ID_APP));
    cls.lpszMenuName   = NULL;
    cls.lpszClassName  = TEXT("WindowsScreenSaverClass");
    cls.hbrBackground  = GetStockObject (BLACK_BRUSH);
    cls.hInstance      = hInst;
    cls.style          = CS_VREDRAW | CS_HREDRAW | CS_DBLCLKS;
    cls.lpfnWndProc    = ScreenSaverProc;
    cls.cbWndExtra     = 0;
    cls.cbClsExtra     = 0;

    if (!RegisterClass (&cls))
        return FALSE;

    hMainWindow = CreateWindowEx (WS_EX_TOPMOST,
                            TEXT("WindowsScreenSaverClass"), // Class name
                            TEXT("\0"),                      // Caption
                            WS_POPUP | WS_VISIBLE |          // Style bits
                            WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
                            0, 0,                            // Position
                            640, 480,                        // Size
                            (HWND)NULL,                      // Parent window (no parent)
                            (HMENU)NULL,                     // use class menu
                            (HANDLE)hInst,                   // handle to window instance
                            (LPVOID)NULL                     // no params to pass on
                               );
    if (!hMainWindow) return FALSE;

// Initialize GLIDE
    grGlideInit();
    if (!grSstQueryHardware( &hwconfig )) {
        DestroyWindow( hMainWindow );
        grGlideShutdown();
        MessageBox( NULL, " ERROR: No Voodoo or Voodoo RUSH detected!", "TTT's Asteroid Flight ScreenSaver", MB_OK | MB_APPLMODAL );
        return FALSE;
    }

    grSstSelect(0);
    if (!grSstWinOpen( (long)hMainWindow,
                       GR_RESOLUTION_640x480,
                       GR_REFRESH_60Hz,
                       GR_COLORFORMAT_RGBA,
                       GR_ORIGIN_UPPER_LEFT,
                       2, 1 ) ) {
        DestroyWindow( hMainWindow );
        grGlideShutdown();
        MessageBox( NULL, " ERROR: Cannot create display context! Something is very wrong!", "TTT's Asteroid Flight ScreenSaver", MB_OK | MB_APPLMODAL );
        return FALSE;
    }

    SetCursor( NULL );              // Wipe the cursor away
    SetFPU();                       // Set FPU precision to only 24 bits

// Clear the 3Dfx logo
    grBufferClear(0,0,GR_WDEPTHVALUE_NEAREST); grBufferSwap(1);
    grBufferClear(0,0,GR_WDEPTHVALUE_NEAREST); grBufferSwap(1);
    grBufferClear(0,0,GR_WDEPTHVALUE_NEAREST); grBufferSwap(1);
    grBufferClear(0,0,GR_WDEPTHVALUE_NEAREST); grBufferSwap(1);

// Load textures
    for(i=0;i<NUM_TEXTURES;i++) {
        lstrcpy(buf, data_directory);
        if (buf[ lstrlen(buf) - 1 ] != '\\')
            lstrcat(buf, "\\");
        lstrcat(buf, texture_names[i]);
        Load_Texture( buf );
    }

// Initialize background polygon rendering & stuff
    Init();
// Set texture-mapping options (bilinear filtering, wrap U & V)
    grTexMipMapMode( GR_TMU0, GR_MIPMAP_NEAREST, FXFALSE );
    grTexFilterMode( GR_TMU0, GR_TEXTUREFILTER_BILINEAR, GR_TEXTUREFILTER_BILINEAR );
    grTexClampMode( GR_TMU0, GR_TEXTURECLAMP_WRAP, GR_TEXTURECLAMP_WRAP );
    grTexCombine( GR_TMU0, GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_NONE,
 	                    GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_NONE,
 	                    FXFALSE, FXFALSE ); 
    grDepthBufferMode( GR_DEPTHBUFFER_WBUFFER );

    Set_Active_Texture(0);
    grTexDownloadTable(GR_TMU0, GR_TEXTABLE_PALETTE, &mypalette );
    step = 0;
    Depth = 3000.0;
    curtex = 0;
    curobj = (rand() % NUM_OBJECTS);
    Load_Object( curobj );

//
// MAINLOOP : Render everything and parse only the necessary Windows messages.
//
    while( quit == 0 ) {

        switch( step ) {
            case 0:
                if (FadeToWhite( &mypalette )) {
                    step++;
                }
                grTexDownloadTable(GR_TMU0, GR_TEXTABLE_PALETTE, &mypalette );
                break;
            case 1:
                if (FadeDownTo( &mypalette, &texture_data[curtex].fileinfo.table.palette )) {
                    step++;
                    rotate_space = 1;
                }
                grTexDownloadTable(GR_TMU0, GR_TEXTABLE_PALETTE, &mypalette );
                break;
            case 2:
                Depth -= 10.0;
                if (Depth < 450.0)
                    step++;
                break;
            case 3:
                start_time = GetTickCount();
                step++;
                break;
            case 4:
                elapsed = GetTickCount() - start_time;
                if (elapsed > 15000)
                    step++;
                break;
            case 5:
                Depth += 10.0;
                if (Depth > 3000.0)
                    step++;
                break;
            case 6:
                if (FadeOutToBlack( &mypalette )) {
                    step = 0;
                    xspeed = (float)(rand() % 7) / 2.5;
                    yspeed = (float)(rand() % 7) / 2.5;
                    zspeed = -(float)(rand() % 7) / 2.5;

                    if (xspeed == 0.0) xspeed += 1.0;
                    if (yspeed == 0.0) yspeed -= 1.0;
                    if (zspeed == 0.0) zspeed -= 2.0;

                    newtex = (rand() % 5);
                    if (newtex == curtex) {
                        newtex++;
                        if (newtex >= num_textures)
                            newtex = 0;
                    }
                    curtex = newtex;
                    Set_Active_Texture(curtex);

                    newobj = (rand() % NUM_OBJECTS);
                    if (newobj == curobj) {
                        newobj++;
                        if (newobj >= NUM_OBJECTS)
                            newobj = 0;
                    }
                    curobj = newobj;
                    Load_Object( curobj );
                }
                grTexDownloadTable(GR_TMU0, GR_TEXTABLE_PALETTE, &mypalette );
                break;
        }


//
// STEP 1:
// Render 2 big background polygons so we don't have to clear the screen.
// Here we also change the WBUFFER combine function so that ALL the values
// in the depthbuffer will be set.
//
// Here we do a simple motion blur with alpha blending.
//
        grDepthMask(1);
        grConstantColorValue( 175 );

        grAlphaCombine( GR_COMBINE_FUNCTION_LOCAL,
                    GR_COMBINE_FACTOR_NONE,
                    GR_COMBINE_LOCAL_CONSTANT,
                    GR_COMBINE_OTHER_NONE,
                    FXFALSE );

        grAlphaBlendFunction( GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA,
		        GR_BLEND_ZERO, GR_BLEND_ZERO );
        grColorCombine( GR_COMBINE_FUNCTION_SCALE_OTHER,
                        GR_COMBINE_FACTOR_ONE,
                        GR_COMBINE_LOCAL_NONE,
                        GR_COMBINE_OTHER_TEXTURE, FXFALSE );
        grCullMode( GR_CULL_DISABLE );
        grDepthBufferFunction( GR_CMP_ALWAYS );
        TransformSpace();
        DrawSpace();

//
// STEP 2:
// Render the object
//
        grConstantColorValue(0);
        grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ONE, GR_BLEND_ZERO);
        grAlphaCombine( GR_COMBINE_FUNCTION_LOCAL,
                    GR_COMBINE_FACTOR_NONE,
                    GR_COMBINE_LOCAL_NONE,
                    GR_COMBINE_OTHER_NONE,
                    FXFALSE );
        grColorCombine( GR_COMBINE_FUNCTION_SCALE_OTHER,
                        GR_COMBINE_FACTOR_ONE,
                        GR_COMBINE_LOCAL_NONE,
                        GR_COMBINE_OTHER_TEXTURE, FXFALSE );
        grCullMode( GR_CULL_POSITIVE );
        grDepthBufferFunction( GR_CMP_LESS );

        TransformObjects();
        DrawObject();
        grBufferSwap(1);

        if (rotate_space) {
            SpaceOrientation.y += yspeed;
            SpaceOrientation.z += zspeed;
            SpaceOrientation.x -= xspeed;
        }

        ObjectOrientation.z += zspeed;
        ObjectOrientation.x -= xspeed;
        ObjectOrientation.y += yspeed;
        current_frame++;
        Sleep(2);
        if (!GetMessage( &msg, hMainWindow, 0, 0))
            quit = 1;
        else {
            switch( msg.message ) {
                case WM_MOUSEMOVE:
                    if (!here) {
                        GetCursorPos (&ptLast);
                        here = TRUE;
                    } else {
                        GetCursorPos (&ptCheck);
                        if (ptCursor.x = ptCheck.x - ptLast.x) {
                            if (ptCursor.x < 0)
                                ptCursor.x *= -1;
                        }
                        if (ptCursor.y = ptCheck.y - ptLast.y) {
                            if (ptCursor.y < 0)
                                ptCursor.y *= -1;
                        }
                        if ((ptCursor.x + ptCursor.y) > 4)
                            quit = 1;
                    }
                    break;
                case WM_LBUTTONDOWN:            // Quit if anything happens
                case WM_MBUTTONDOWN:
                case WM_RBUTTONDOWN:
                case WM_KEYDOWN:
                    quit = 1;
                    break;
            }
        }
    }
    grGlideShutdown();
    DestroyWindow( hMainWindow );
    return 0;
}



///////////////////////////////////////////////////////////////////////
///                                                                 ///
/// WINDOW PROCEDURE                                                ///
///                                                                 ///
///////////////////////////////////////////////////////////////////////
// This is just a dummy procedure. It is ONLY used to create the WM_TIMER
// so that the loop above keeps getting information.

#define MY_TIMER            105

LRESULT CALLBACK ScreenSaverProc(HWND hwnd, UINT message, WPARAM uParam, LPARAM lParam) {
  switch( message ) {
    case WM_CREATE:
        SetTimer( hwnd, 105, 1, NULL );
        SetCapture( hwnd );
        break;
    case WM_DESTROY:
        ReleaseCapture();
        KillTimer( hwnd, 105 );
        PostQuitMessage(0);
        return 0;
  } 
  return DefWindowProc( hwnd, message, uParam, lParam );
};


