/*
 * TTT's Modern Dreams - Screensaver
 *	Copyright (c) 1998 Tauno Taipaleenmki <tataipal@mail.student.oulu.fi>,
 *	All rights reserved.
 *
 *         FILE : 3D.CPP
 *		PURPOSE : Simple 3D Transformations
 *		VERSION : 1.00
 * LAST CHANGED : 28/02/1998
 *
 * NOTES: -
 *
 */

// Degree to radian conversion factor
#define DEG_TO_RAD	3.141592654 / 180.0

//
// Multiply two matrices
//
void MatMul(matrix a, matrix b, matrix c)
{
	int 		i,j;

	for(i=0;i<3;i++) {
		for(j=0;j<3;j++) {
			c[i][j] = a[i][0]*b[0][j] +
					  a[i][1]*b[1][j] +
					  a[i][2]*b[2][j];
		}
	}
}

//
// Build the object rotation matrix
//
void Build_Object_Matrix(void)
{
    matrix          x,y,z,temp1;
	float			sx,sy,sz,cx,cy,cz;

	sx = sin( ObjectOrientation.x * DEG_TO_RAD );
	cx = cos( ObjectOrientation.x * DEG_TO_RAD );
	sy = sin( ObjectOrientation.y * DEG_TO_RAD );
	cy = cos( ObjectOrientation.y * DEG_TO_RAD );
	sz = sin( ObjectOrientation.z * DEG_TO_RAD );
	cz = cos( ObjectOrientation.z * DEG_TO_RAD );

// Around X
    x[0][0] = 1.0;  x[0][1] = 0.0;  x[0][2] = 0.0;
    x[1][0] = 0.0;  x[1][1] =  cx;  x[1][2] = -sx;
    x[2][0] = 0.0;  x[2][1] =  sx;  x[2][2] =  cx;
// Around Y
    y[0][0] =  cy;  y[0][1] = 0.0;  y[0][2] = -sy;
    y[1][0] = 0.0;  y[1][1] = 1.0;  y[1][2] = 0.0;
    y[2][0] =  sy;  y[2][1] = 0.0;  y[2][2] =  cy;
// Around Z
    z[0][0] =  cz;  z[0][1] = -sz;  z[0][2] = 0.0;
    z[1][0] =  sz;  z[1][1] =  cz;  z[1][2] = 0.0;
    z[2][0] = 0.0;  z[2][1] = 0.0;  z[2][2] = 1.0;

    MatMul(x,y,temp1);
    MatMul(temp1,z,ObjectMatrix);
}

//
// Transform the object into camera coordinates
//
void TransformObjects(void)
{
    int                 i;
    matrix              final;
    float               x,y,z,dx,dy,dz,nx,ny;

    Build_Object_Matrix();          // Build object->world

    for(i=0;i<NUM_VERTICES;i++) {
        x = vertex_list[i].x * ObjectMatrix[0][0] +       // Rotate
            vertex_list[i].y * ObjectMatrix[0][1] +
            vertex_list[i].z * ObjectMatrix[0][2];
        y = vertex_list[i].x * ObjectMatrix[1][0] +
            vertex_list[i].y * ObjectMatrix[1][1] +
            vertex_list[i].z * ObjectMatrix[1][2];
        z = vertex_list[i].x * ObjectMatrix[2][0] +
            vertex_list[i].y * ObjectMatrix[2][1] +
            vertex_list[i].z * ObjectMatrix[2][2];
                                                        // Rotate normals
        nx = vertex_list[i].nx * ObjectMatrix[0][0] +
             vertex_list[i].ny * ObjectMatrix[0][1] +
             vertex_list[i].nz * ObjectMatrix[0][2];
        ny = vertex_list[i].nx * ObjectMatrix[1][0] +
             vertex_list[i].ny * ObjectMatrix[1][1] +
             vertex_list[i].nz * ObjectMatrix[1][2];

        z += Depth;                        // Simple perspective projection
        if (z < 2.0)
            z = 2.0;

        dz = 256.0 / z;
        dx = 320.0 + x * dz;
        dy = 240.0 + y * dz;

        final_vertices[i].x              = dx + ((float)(3 << 18));
        final_vertices[i].y              = dy + ((float)(3 << 18));
        final_vertices[i].oow            = dz;
        final_vertices[i].tmuvtx[0].sow  = (1-nx)*dz;
        final_vertices[i].tmuvtx[0].tow  = (1-ny)*dz;
        final_vertices[i].r              = 255.0;
        final_vertices[i].g              = 255.0;
        final_vertices[i].b              = 255.0;
        final_vertices[i].tmuvtx[0].oow  = final_vertices[i].oow;
        final_vertices[i].a              = 255.0;
    }
}

//
// Draw the object. No clipping is necessary because we are always
// drawing within screen boundaries.
//
void DrawObject(void)
{
    int     i;

//    Set_Active_Texture(0);

    for(i=0;i<NUM_POLYGONS;i++) {
        grDrawTriangle( &final_vertices[ face_list[i].v1 ],
                        &final_vertices[ face_list[i].v2 ],
                        &final_vertices[ face_list[i].v3 ] );
    }
}


//
// Build the space-object rotation matrix
//
void Build_Space_Matrix(void)
{
    matrix          x,y,z,temp1;
	float			sx,sy,sz,cx,cy,cz;

    sx = sin( SpaceOrientation.x * DEG_TO_RAD );
    cx = cos( SpaceOrientation.x * DEG_TO_RAD );
    sy = sin( SpaceOrientation.y * DEG_TO_RAD );
    cy = cos( SpaceOrientation.y * DEG_TO_RAD );
    sz = sin( SpaceOrientation.z * DEG_TO_RAD );
    cz = cos( SpaceOrientation.z * DEG_TO_RAD );

// Around X
    x[0][0] = 1.0;  x[0][1] = 0.0;  x[0][2] = 0.0;
    x[1][0] = 0.0;  x[1][1] =  cx;  x[1][2] = -sx;
    x[2][0] = 0.0;  x[2][1] =  sx;  x[2][2] =  cx;
// Around Y
    y[0][0] =  cy;  y[0][1] = 0.0;  y[0][2] = -sy;
    y[1][0] = 0.0;  y[1][1] = 1.0;  y[1][2] = 0.0;
    y[2][0] =  sy;  y[2][1] = 0.0;  y[2][2] =  cy;
// Around Z
    z[0][0] =  cz;  z[0][1] = -sz;  z[0][2] = 0.0;
    z[1][0] =  sz;  z[1][1] =  cz;  z[1][2] = 0.0;
    z[2][0] = 0.0;  z[2][1] = 0.0;  z[2][2] = 1.0;

    MatMul(x,y,temp1);
    MatMul(temp1,z,SpaceMatrix);
}

//
// Transform the space-object into camera coordinates
//
void TransformSpace(void)
{
    int                 i;
    matrix              final;
    float               x,y,z,dx,dy,dz,nx,ny;

    Build_Space_Matrix();

    for(i=0;i<space_verts;i++) {
        x = space_vertices[i][0] * SpaceMatrix[0][0] +       // Rotate
            space_vertices[i][1] * SpaceMatrix[0][1] +
            space_vertices[i][2] * SpaceMatrix[0][2];
        y = space_vertices[i][0] * SpaceMatrix[1][0] +
            space_vertices[i][1] * SpaceMatrix[1][1] +
            space_vertices[i][2] * SpaceMatrix[1][2];
        z = space_vertices[i][0] * SpaceMatrix[2][0] +
            space_vertices[i][1] * SpaceMatrix[2][1] +
            space_vertices[i][2] * SpaceMatrix[2][2];

        z += 3000;
        if (z < 2.0)
            z = 2.0;

        dz = 512.0 / z;
        dx = 320.0 + x * dz;
        dy = 240.0 + y * dz;

        space_final[i].x              = dx + ((float)(3 << 18));
        space_final[i].y              = dy + ((float)(3 << 18));
        space_final[i].oow            = dz;
        space_final[i].tmuvtx[0].sow  = space_uv[i][0] * dz;
        space_final[i].tmuvtx[0].tow  = space_uv[i][1] * dz;
        space_final[i].r              = 255.0;
        space_final[i].g              = 255.0;
        space_final[i].b              = 255.0;
        space_final[i].tmuvtx[0].oow  = space_final[i].oow;
        space_final[i].a              = 255.0;
    }
}

//
// Draw the "space"
//
void DrawSpace(void)
{
    int     i;

    grCullMode( GR_CULL_NEGATIVE );

    for(i=0;i<space_polys;i++) {
        grDrawTriangle( &space_final[ space_surfaces[i][0] ],
                        &space_final[ space_surfaces[i][1] ],
                        &space_final[ space_surfaces[i][2] ] );
    }
}

