from core import Effect, TextureLoader, GLSLShader, FBO
from core.gl import *
import core

import math
from math import cos, sin, fmod
import core
import random


class Tiler(Effect):

    def __init__(self, screenDim):
        Effect.__init__(self,"tiler")

        self._bufferDim = screenDim
        self._fbo = FBO(*self._bufferDim)
        self._screenDim = screenDim

        self.addParameter("scale", interpolate = True)
        self._parameters["scale"][0] = 0
        self._images = {}
        self._filenames = [ "%03d.psd.png" % i for i in xrange(1,50) ]
        self._lastTime = -1
        self.addParameter("enabled", interpolate=False)
        self._parameters["enabled"][0] = 1

    def drawQuad(self, fixCoords, tdims, bbox):
        umin, umax = 0, 1
        vmin, vmax = 0, 1

        xmin, xmax = 0, tdims[0] / float(self._screenDim[0])
        ymin, ymax = 0, tdims[1] / float(self._screenDim[1])

#        print xmin, xmax, ymin, ymax


            #umin += 192/1024.0
            #umax += 192/1024.0
            #vmin += 16.0/512.0
            #vmax += 16.0/512.0

        glBegin(GL_QUADS)

        glTexCoord2f(umin, vmin)
        glVertex2f(xmin, ymin)

        glTexCoord2f(umax, vmin)
        glVertex2f(xmax, ymin)

        glTexCoord2f(umax, vmax)
        glVertex2f(xmax,ymax)

        glTexCoord2f(umin, vmax)
        glVertex2f(xmin,ymax)

        glEnd()

        if bbox:
            glDisable(GL_TEXTURE_2D)
            glColor4f(1,0,1,1)
            glBegin(GL_LINES)
            glVertex2f(xmin, ymin)
            glVertex2f(xmax, ymin)

            glVertex2f(xmax, ymin)
            glVertex2f(xmax,ymax)
            
            glVertex2f(xmax,ymax)
            glVertex2f(xmin,ymax)

            glVertex2f(xmin,ymax)
            glVertex2f(xmin, ymin)

        
            glEnd()



        
    def draw(self, time, delta, start, stop):
#        self._lastTime = -1

        fft = self.fft.getSpectralDensity(0, 10)
        a = fft*.15

        beat = int( (time - 99.21 ) / (1.296/4.0))
        beatpart = int( (time - 99.21 ) / (1.296/16.0))
        self.filename = self._filenames[beat%49]
        a +=  (1.0-fmod((time-99.21) / (1.296/4.0) , 1.0)) * .15



        filename = self.filename

        if filename not in self._images:
            self._images[filename] = TextureLoader(core.filemonitor.findFile(filename))

        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        glOrtho(0,1,1,0,-1,1)



        try:
            texture = self._images[filename]
        except:
            return


        texture.bind(0)
        tdims = [texture.getWidth(), texture.getHeight()]
        

        glEnable(GL_BLEND)
        glBlendFunc(GL_ONE, GL_ONE)

        glColor4f(1,0,0, 0)

        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()

        

        glTranslatef(math.fmod(-a*.1, 1.0),0,0)


        drawCenter = random.random() < .2


        scale = 1

        # vertical stretch
        if fft > 2.5:
            scale = 20
        if fft < 1.5:
            scale = 2
        
            
        glTranslatef(-.5, -.5,0)

        glRotatef(2, 0, 0, 1)

        glTranslatef(.5, .5,0)

        glScalef(1,scale,1)
        glTranslatef(-4*0.33,-0.33,0)
        glColor4f(a,a,a,1)


        glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)

        for i in xrange(8):
            for j in xrange(4):

                if i==1  and j == 1 and not drawCenter:
                    continue

                glPushMatrix()
                glTranslatef(i*.33,j*.33, 0)
                
                self.drawQuad(False, tdims, False)
                glPopMatrix()

        glDisable(GL_TEXTURE_2D)
        glDisable(GL_BLEND)

