
uniform vec3  lights[2];
uniform vec3  colors[2];
uniform float falloff[2];

uniform vec3  eyevec;

uniform samplerCube refmap;

// uniform int nlights;

varying vec3 coord;
varying vec3 normal;

void main ()
{
  vec3 u,c,n;
  float x; 
   
  n = normalize(normal);
   
  u = lights[0] - coord; x = dot( u , n ) / length(u) ; c  = pow(x,falloff[0]) * colors[0];  
  u = lights[1] - coord; x = dot( u , n ) / length(u) ; c += pow(x,falloff[1]) * colors[1];  
  
  u = normalize (eyevec-coord);
  c += textureCube ( refmap , (2.0*dot(u,n)) * n - u ) .xyz ;    // a beepitett reflect fuggveny szar...
  
  gl_FragColor.rgb = c;
}



