
uniform float hue;
uniform vec2 center;      // texture center, like (0.2132123, 0.5)
uniform sampler2D tex;   

uniform float alpha;
uniform float alpha1, alpha2;
uniform float zoom1,  zoom2;

varying vec2 xy,xy1,xy2;          // textura koordinatak relative to the center

const vec4 togray = vec4 (0.30, 0.45, 0.25, 0);
const vec3 sepia  = vec3 (0.6, 1.2, 0.8);

void main()
{
  vec4 col;
  
  col =           texture2D ( tex, center + xy          );
  col += alpha1 * texture2D ( tex, center + xy1 * zoom1 ); 
  col += alpha2 * texture2D ( tex, center + xy2 * zoom2 ); 

  gl_FragColor.rgb = alpha * mix ( sepia * dot(col,togray) , col.rgb , hue );

  return;
  
}


