
uniform vec3  lights; //[2];
uniform vec4  colors; //[2];
uniform float falloff; //[2];

uniform samplerCube refmap;
//uniform sampler2D   perturbmap;

uniform vec3 eyevec;            
uniform vec3 center;              
uniform float radiussquare;
uniform float oneoverradius;

varying vec3 quad;

void main ()
{
  vec4 c;
  vec3 u,v,n,x;
  float z,b,s; 

  v = normalize (eyevec - quad) ;     // eyedir
  u = quad - center;
  b = dot(u,v);                       // B/2 a masodfoku egyenletben
  z = dot(u,u) - radiussquare;        // C   a masodfoku egyenletben.  A = <eyedir,eyedir> = 1
  
  z = b*b - z;  // diszkriminans
  if (z<0.0) discard;
  
  z = sqrt(z);  

  x = u + (- b + z ) * v ;      
  n = x * oneoverradius;    // normal vektor
  x += center;              // raytrace metszes koordinataja

  u = lights - x;
  s = max( 0.0 , dot( u , n ) / length(u) ) ; c = (0.6* pow( s , falloff )) * colors ;  

  u = normalize ( eyevec - x );
  c += 0.7*textureCube ( refmap , (2.0*dot(u,n)) * n - u ) ;    // a beepitett reflect fuggveny szar...

  x = quad - center + (- b - z ) * v;   
  n = - x * oneoverradius;    // normal vektor
  x += center;              // raytrace metszes koordinataja
  
  u = normalize ( eyevec - x);
  c += 0.45*textureCube ( refmap , (2.0*dot(u,n)) * n - u ) ;    // a beepitett reflect fuggveny szar...
    
  gl_FragColor = c;

//  u = lights[1] - coord; z = dot( u , n ) / length(u) ; c += pow(x,falloff[1]) * colors[1];  
  
}

/*
void main ()
{
  vec4 c;
  vec3 u,n,coord;
  float z; 
  
  z = 0.25 - dot ( uv , uv );
  if (z<0.0) discard;
  z = sqrt(z);         // z koordinata, 0.5 sugaru gomb a kozeppont korul
   
  n.xy = uv;
  n.z  = z;
  n *= 2.0;
  
  coord = center + radius * n;
   
//  u = lights[0] - coord; z = dot( u , n ) / length(u) ; c  = pow(x,falloff[0]) * colors[0];  
//  u = lights[1] - coord; z = dot( u , n ) / length(u) ; c += pow(x,falloff[1]) * colors[1];  
  
  u = normalize (eyevec-coord);
  c = textureCube ( refmap , (2.0*dot(u,n)) * n - u ) ;    // a beepitett reflect fuggveny szar...
  
  n.z = -n.z;
  coord = center + radius * n;
  u = normalize (eyevec-coord);
  n = -n;

  c += 0.7 * textureCube ( refmap , (2.0*dot(u,n)) * n - u ) ;    // a beepitett reflect fuggveny szar...
  
  gl_FragColor = c;
}
*/