/*
 * Decompiled with CFR 0.152.
 */
package plugins.neheshadow;

import java.io.FileReader;
import java.io.StreamTokenizer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import opengl.common;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;
import org.lwjgl.opengl.glu.Sphere;
import plug.plugin;
import plug.pluginIF;
import plugins.neheshadow.GlObject;
import plugins.neheshadow.Plane;
import plugins.neheshadow.Point;
import vsysTypes.vColor;

public class neheshadow
extends plugin
implements pluginIF {
    public vColor color;
    private boolean done = false;
    private boolean fullscreen = false;
    private final String windowTitle = "NeHe's OpenGL Lesson 27 for LWJGL (Shadows)";
    private boolean f1 = false;
    private DisplayMode displayMode;
    GlObject obj;
    float xrot = 0.0f;
    float xspeed = 0.0f;
    float yrot = 0.0f;
    float yspeed = 0.0f;
    float[] lightPos = new float[]{0.0f, 5.0f, -4.0f, 1.0f};
    float[] lightAmb = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
    float[] lightDif = new float[]{0.6f, 0.6f, 0.6f, 1.0f};
    float[] lightSpc = new float[]{-0.2f, -0.2f, -0.2f, 1.0f};
    ByteBuffer byteBuffer;
    ByteBuffer floatBuffer;
    float[] matAmb = new float[]{0.4f, 0.4f, 0.4f, 1.0f};
    float[] matDif = new float[]{0.2f, 0.6f, 0.9f, 1.0f};
    float[] matSpc = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    float[] matShn = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    float[] objPos = new float[]{-2.0f, -2.0f, -5.0f};
    Sphere q;
    float[] spherePos = new float[]{-4.0f, -5.0f, -6.0f};

    @Override
    public String getName() {
        return "clearscreen";
    }

    @Override
    public String getAuthor() {
        return "pandur";
    }

    @Override
    public float getVersion() {
        return 1.5f;
    }

    @Override
    public void init() {
    }

    private void mainloop() {
        if (Keyboard.isKeyDown(1)) {
            this.done = true;
        }
        if (Display.isCloseRequested()) {
            this.done = true;
        }
        if (Keyboard.isKeyDown(59) && !this.f1) {
            this.f1 = true;
            this.switchMode();
        }
        if (!Keyboard.isKeyDown(59)) {
            this.f1 = false;
        }
        if (Keyboard.isKeyDown(203)) {
            this.yspeed -= 0.1f;
        }
        if (Keyboard.isKeyDown(205)) {
            this.yspeed += 0.1f;
        }
        if (Keyboard.isKeyDown(200)) {
            this.xspeed -= 0.1f;
        }
        if (Keyboard.isKeyDown(208)) {
            this.xspeed += 0.1f;
        }
        if (Keyboard.isKeyDown(38)) {
            this.lightPos[0] = this.lightPos[0] + 0.05f;
        }
        if (Keyboard.isKeyDown(36)) {
            this.lightPos[0] = this.lightPos[0] - 0.05f;
        }
        if (Keyboard.isKeyDown(23)) {
            this.lightPos[1] = this.lightPos[1] + 0.05f;
        }
        if (Keyboard.isKeyDown(37)) {
            this.lightPos[1] = this.lightPos[1] - 0.05f;
        }
        if (Keyboard.isKeyDown(24)) {
            this.lightPos[2] = this.lightPos[2] + 0.05f;
        }
        if (Keyboard.isKeyDown(22)) {
            this.lightPos[2] = this.lightPos[2] - 0.05f;
        }
        if (Keyboard.isKeyDown(77)) {
            this.objPos[0] = this.objPos[0] + 0.05f;
        }
        if (Keyboard.isKeyDown(75)) {
            this.objPos[0] = this.objPos[0] - 0.05f;
        }
        if (Keyboard.isKeyDown(72)) {
            this.objPos[1] = this.objPos[1] + 0.05f;
        }
        if (Keyboard.isKeyDown(76)) {
            this.objPos[1] = this.objPos[1] - 0.05f;
        }
        if (Keyboard.isKeyDown(73)) {
            this.objPos[2] = this.objPos[2] + 0.05f;
        }
        if (Keyboard.isKeyDown(71)) {
            this.objPos[2] = this.objPos[2] - 0.05f;
        }
        if (Keyboard.isKeyDown(32)) {
            this.spherePos[0] = this.spherePos[0] + 0.05f;
        }
        if (Keyboard.isKeyDown(30)) {
            this.spherePos[0] = this.spherePos[0] - 0.05f;
        }
        if (Keyboard.isKeyDown(17)) {
            this.spherePos[1] = this.spherePos[1] + 0.05f;
        }
        if (Keyboard.isKeyDown(31)) {
            this.spherePos[1] = this.spherePos[1] - 0.05f;
        }
        if (Keyboard.isKeyDown(18)) {
            this.spherePos[2] = this.spherePos[2] + 0.05f;
        }
        if (Keyboard.isKeyDown(16)) {
            this.spherePos[2] = this.spherePos[2] - 0.05f;
        }
    }

    private void switchMode() {
        this.fullscreen = !this.fullscreen;
        try {
            Display.setFullscreen(this.fullscreen);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createWindow() throws Exception {
        Display.setFullscreen(this.fullscreen);
        DisplayMode[] d = Display.getAvailableDisplayModes();
        int i = 0;
        while (i < d.length) {
            if (d[i].getWidth() == 640 && d[i].getHeight() == 480 && d[i].getBitsPerPixel() == 32) {
                this.displayMode = d[i];
                break;
            }
            ++i;
        }
        Display.setDisplayMode(this.displayMode);
        Display.setTitle("NeHe's OpenGL Lesson 27 for LWJGL (Shadows)");
        Display.create();
    }

    private void initGL() {
        this.initGLObjects();
        int width = common.currentContextWidth;
        int height = common.currentContextHeight;
        GL11.glShadeModel(7425);
        GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.5f);
        GL11.glClearDepth(1.0);
        GL11.glClearStencil(0);
        GL11.glEnable(2929);
        GL11.glDepthFunc(515);
        GL11.glHint(3152, 4354);
        this.floatBuffer = ByteBuffer.allocateDirect(64);
        this.floatBuffer.order(ByteOrder.nativeOrder());
        this.byteBuffer = ByteBuffer.allocateDirect(16);
        this.byteBuffer.order(ByteOrder.nativeOrder());
        GL11.glLight(16385, 4611, (FloatBuffer)this.byteBuffer.asFloatBuffer().put(this.lightPos).flip());
        GL11.glLight(16385, 4608, (FloatBuffer)this.byteBuffer.asFloatBuffer().put(this.lightAmb).flip());
        GL11.glLight(16385, 4609, (FloatBuffer)this.byteBuffer.asFloatBuffer().put(this.lightDif).flip());
        GL11.glLight(16385, 4610, (FloatBuffer)this.byteBuffer.asFloatBuffer().put(this.lightSpc).flip());
        GL11.glEnable(16385);
        GL11.glEnable(2896);
        GL11.glMaterial(1028, 4608, (FloatBuffer)this.byteBuffer.asFloatBuffer().put(this.matAmb).flip());
        GL11.glMaterial(1028, 4609, (FloatBuffer)this.byteBuffer.asFloatBuffer().put(this.matDif).flip());
        GL11.glMaterial(1028, 4610, (FloatBuffer)this.byteBuffer.asFloatBuffer().put(this.matSpc).flip());
        GL11.glMaterial(1028, 5633, (FloatBuffer)this.byteBuffer.asFloatBuffer().put(this.matShn).flip());
        GL11.glCullFace(1029);
        GL11.glEnable(2884);
        GL11.glClearColor(0.1f, 1.0f, 0.5f, 1.0f);
        this.q = new Sphere();
        this.q.setNormals(7425);
        this.q.setTextureFlag(false);
        GL11.glViewport(0, 0, width, height);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective(45.0f, (float)common.currentContextWidth / (float)common.currentContextHeight, 0.1f, 100.0f);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
    }

    private void vMatMult(float[] M, float[] v) {
        float[] res = new float[]{M[0] * v[0] + M[4] * v[1] + M[8] * v[2] + M[12] * v[3], M[1] * v[0] + M[5] * v[1] + M[9] * v[2] + M[13] * v[3], M[2] * v[0] + M[6] * v[1] + M[10] * v[2] + M[14] * v[3], M[3] * v[0] + M[7] * v[1] + M[11] * v[2] + M[15] * v[3]};
        v[0] = res[0];
        v[1] = res[1];
        v[2] = res[2];
        v[3] = res[3];
    }

    private void initGLObjects() {
        this.obj = new GlObject();
        this.readObject("C:/Dokumente und Einstellungen/tom/Desktop/lesson27/Lesson27/Data/Object.txt", this.obj);
        this.setConnectivity(this.obj);
        int i = 0;
        while (i < this.obj.nPlanes) {
            this.calcPlane(this.obj, this.obj.planes[i]);
            ++i;
        }
    }

    private void drawGLRoom() {
        GL11.glBegin(7);
        GL11.glNormal3f(0.0f, 1.0f, 0.0f);
        GL11.glVertex3f(-10.0f, -10.0f, -20.0f);
        GL11.glVertex3f(-10.0f, -10.0f, 20.0f);
        GL11.glVertex3f(10.0f, -10.0f, 20.0f);
        GL11.glVertex3f(10.0f, -10.0f, -20.0f);
        GL11.glNormal3f(0.0f, -1.0f, 0.0f);
        GL11.glVertex3f(-10.0f, 10.0f, 20.0f);
        GL11.glVertex3f(-10.0f, 10.0f, -20.0f);
        GL11.glVertex3f(10.0f, 10.0f, -20.0f);
        GL11.glVertex3f(10.0f, 10.0f, 20.0f);
        GL11.glNormal3f(0.0f, 0.0f, 1.0f);
        GL11.glVertex3f(-10.0f, 10.0f, -20.0f);
        GL11.glVertex3f(-10.0f, -10.0f, -20.0f);
        GL11.glVertex3f(10.0f, -10.0f, -20.0f);
        GL11.glVertex3f(10.0f, 10.0f, -20.0f);
        GL11.glNormal3f(0.0f, 0.0f, -1.0f);
        GL11.glVertex3f(10.0f, 10.0f, 20.0f);
        GL11.glVertex3f(10.0f, -10.0f, 20.0f);
        GL11.glVertex3f(-10.0f, -10.0f, 20.0f);
        GL11.glVertex3f(-10.0f, 10.0f, 20.0f);
        GL11.glNormal3f(1.0f, 0.0f, 0.0f);
        GL11.glVertex3f(-10.0f, 10.0f, 20.0f);
        GL11.glVertex3f(-10.0f, -10.0f, 20.0f);
        GL11.glVertex3f(-10.0f, -10.0f, -20.0f);
        GL11.glVertex3f(-10.0f, 10.0f, -20.0f);
        GL11.glNormal3f(-1.0f, 0.0f, 0.0f);
        GL11.glVertex3f(10.0f, 10.0f, -20.0f);
        GL11.glVertex3f(10.0f, -10.0f, -20.0f);
        GL11.glVertex3f(10.0f, -10.0f, 20.0f);
        GL11.glVertex3f(10.0f, 10.0f, 20.0f);
        GL11.glEnd();
    }

    @Override
    public void render() {
        this.initGL();
        float[] Minv = new float[16];
        float[] wlp = new float[4];
        float[] lp = new float[4];
        GL11.glClear(17664);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -20.0f);
        GL11.glLight(16385, 4611, (FloatBuffer)this.byteBuffer.asFloatBuffer().put(this.lightPos).flip());
        GL11.glTranslatef(this.spherePos[0], this.spherePos[1], this.spherePos[2]);
        this.q.draw(1.5f, 32, 16);
        GL11.glLoadIdentity();
        GL11.glRotatef(-this.yrot, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(-this.xrot, 1.0f, 0.0f, 0.0f);
        GL11.glGetFloat(2982, (FloatBuffer)this.floatBuffer.asFloatBuffer().put(Minv).flip());
        lp[0] = this.lightPos[0];
        lp[1] = this.lightPos[1];
        lp[2] = this.lightPos[2];
        lp[3] = this.lightPos[3];
        this.vMatMult(Minv, lp);
        GL11.glTranslatef(-this.objPos[0], -this.objPos[1], -this.objPos[2]);
        GL11.glGetFloat(2982, (FloatBuffer)this.floatBuffer.asFloatBuffer().put(Minv).flip());
        wlp[0] = 0.0f;
        wlp[1] = 0.0f;
        wlp[2] = 0.0f;
        wlp[3] = 1.0f;
        this.vMatMult(Minv, wlp);
        lp[0] = lp[0] + wlp[0];
        lp[1] = lp[1] + wlp[1];
        lp[2] = lp[2] + wlp[2];
        GL11.glColor4f(0.7f, 0.4f, 0.0f, 1.0f);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -20.0f);
        this.drawGLRoom();
        GL11.glTranslatef(this.objPos[0], this.objPos[1], this.objPos[2]);
        GL11.glRotatef(this.xrot, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.yrot, 0.0f, 1.0f, 0.0f);
        this.drawGLObject(this.obj);
        this.castShadow(this.obj, lp);
        GL11.glColor4f(0.7f, 0.4f, 0.0f, 1.0f);
        GL11.glDisable(2896);
        GL11.glDepthMask(false);
        GL11.glTranslatef(lp[0], lp[1], lp[2]);
        this.q.draw(0.2f, 16, 8);
        GL11.glEnable(2896);
        GL11.glDepthMask(true);
        this.xrot += this.xspeed;
        this.yrot += this.yspeed;
        GL11.glFlush();
    }

    private void readObject(String name, GlObject o) {
        try {
            StreamTokenizer in = new StreamTokenizer(new FileReader(name));
            in.nextToken();
            o.nPoints = (int)in.nval;
            int i = 0;
            while (i < o.nPoints) {
                in.nextToken();
                o.points[i].x = (float)in.nval;
                in.nextToken();
                o.points[i].y = (float)in.nval;
                in.nextToken();
                o.points[i].z = (float)in.nval;
                ++i;
            }
            in.nextToken();
            o.nPlanes = (int)in.nval;
            i = 0;
            while (i < o.nPlanes) {
                in.nextToken();
                o.planes[i].p[0] = (int)in.nval;
                in.nextToken();
                o.planes[i].p[1] = (int)in.nval;
                in.nextToken();
                o.planes[i].p[2] = (int)in.nval;
                in.nextToken();
                o.planes[i].normals[0].x = (float)in.nval;
                in.nextToken();
                o.planes[i].normals[0].y = (float)in.nval;
                in.nextToken();
                o.planes[i].normals[0].z = (float)in.nval;
                in.nextToken();
                o.planes[i].normals[1].x = (float)in.nval;
                in.nextToken();
                o.planes[i].normals[1].y = (float)in.nval;
                in.nextToken();
                o.planes[i].normals[1].z = (float)in.nval;
                in.nextToken();
                o.planes[i].normals[2].x = (float)in.nval;
                in.nextToken();
                o.planes[i].normals[2].y = (float)in.nval;
                in.nextToken();
                o.planes[i].normals[2].z = (float)in.nval;
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setConnectivity(GlObject o) {
        int i = 0;
        while (i < o.nPlanes - 1) {
            int j = i + 1;
            while (j < o.nPlanes) {
                int ki = 0;
                while (ki < 3) {
                    if (o.planes[i].neigh[ki] != 0) {
                        int kj = 0;
                        while (kj < 3) {
                            int p1i = ki;
                            int p1j = kj;
                            int p2i = (ki + 1) % 3;
                            int p2j = (kj + 1) % 3;
                            p1i = o.planes[i].p[p1i];
                            p2i = o.planes[i].p[p2i];
                            p1j = o.planes[j].p[p1j];
                            p2j = o.planes[j].p[p2j];
                            int P1i = (p1i + p2i - Math.abs(p1i - p2i)) / 2;
                            int P2i = (p1i + p2i + Math.abs(p1i - p2i)) / 2;
                            int P1j = (p1j + p2j - Math.abs(p1j - p2j)) / 2;
                            int P2j = (p1j + p2j + Math.abs(p1j - p2j)) / 2;
                            if (P1i == P1j && P2i == P2j) {
                                o.planes[i].neigh[ki] = j + 1;
                                o.planes[j].neigh[kj] = i + 1;
                            }
                            ++kj;
                        }
                    }
                    ++ki;
                }
                ++j;
            }
            ++i;
        }
    }

    private void calcPlane(GlObject o, Plane plane) {
        Point[] v = new Point[4];
        int i = 0;
        while (i < 4) {
            v[i] = new Point();
            ++i;
        }
        i = 0;
        while (i < 3) {
            v[i + 1].x = o.points[plane.p[i]].x;
            v[i + 1].y = o.points[plane.p[i]].y;
            v[i + 1].z = o.points[plane.p[i]].z;
            ++i;
        }
        plane.planeEq.a = v[1].y * (v[2].z - v[3].z) + v[2].y * (v[3].z - v[1].z) + v[3].y * (v[1].z - v[2].z);
        plane.planeEq.b = v[1].z * (v[2].x - v[3].x) + v[2].z * (v[3].x - v[1].x) + v[3].z * (v[1].x - v[2].x);
        plane.planeEq.c = v[1].x * (v[2].y - v[3].y) + v[2].x * (v[3].y - v[1].y) + v[3].x * (v[1].y - v[2].y);
        plane.planeEq.d = -(v[1].x * (v[2].y * v[3].z - v[3].y * v[2].z) + v[2].x * (v[3].y * v[1].z - v[1].y * v[3].z) + v[3].x * (v[1].y * v[2].z - v[2].y * v[1].z));
    }

    private void drawGLObject(GlObject o) {
        GL11.glBegin(4);
        int i = 0;
        while (i < o.nPlanes) {
            int j = 0;
            while (j < 3) {
                GL11.glNormal3f(o.planes[i].normals[j].x, o.planes[i].normals[j].y, o.planes[i].normals[j].z);
                GL11.glVertex3f(o.points[o.planes[i].p[j]].x, o.points[o.planes[i].p[j]].y, o.points[o.planes[i].p[j]].z);
                ++j;
            }
            ++i;
        }
        GL11.glEnd();
    }

    private void castShadow(GlObject o, float[] lp) {
        int p2;
        int jj;
        int p1;
        int k;
        int j;
        Point v1 = new Point();
        Point v2 = new Point();
        int i = 0;
        while (i < o.nPlanes) {
            float side = o.planes[i].planeEq.a * lp[0] + o.planes[i].planeEq.b * lp[1] + o.planes[i].planeEq.c * lp[2] + o.planes[i].planeEq.d * lp[3];
            o.planes[i].visible = side > 0.0f;
            ++i;
        }
        GL11.glDisable(2896);
        GL11.glDepthMask(false);
        GL11.glDepthFunc(515);
        GL11.glEnable(2960);
        GL11.glColorMask(false, false, false, false);
        GL11.glStencilFunc(519, 1, -1);
        GL11.glFrontFace(2305);
        GL11.glStencilOp(7680, 7680, 7682);
        i = 0;
        while (i < o.nPlanes) {
            if (o.planes[i].visible) {
                j = 0;
                while (j < 3) {
                    k = o.planes[i].neigh[j];
                    if (k != 0 || !o.planes[k - 1].visible) {
                        p1 = o.planes[i].p[j];
                        jj = (j + 1) % 3;
                        p2 = o.planes[i].p[jj];
                        v1.x = (o.points[p1].x - lp[0]) * 100.0f;
                        v1.y = (o.points[p1].y - lp[1]) * 100.0f;
                        v1.z = (o.points[p1].z - lp[2]) * 100.0f;
                        v2.x = (o.points[p2].x - lp[0]) * 100.0f;
                        v2.y = (o.points[p2].y - lp[1]) * 100.0f;
                        v2.z = (o.points[p2].z - lp[2]) * 100.0f;
                        GL11.glBegin(5);
                        GL11.glVertex3f(o.points[p1].x, o.points[p1].y, o.points[p1].z);
                        GL11.glVertex3f(o.points[p1].x + v1.x, o.points[p1].y + v1.y, o.points[p1].z + v1.z);
                        GL11.glVertex3f(o.points[p2].x, o.points[p2].y, o.points[p2].z);
                        GL11.glVertex3f(o.points[p2].x + v2.x, o.points[p2].y + v2.y, o.points[p2].z + v2.z);
                        GL11.glEnd();
                    }
                    ++j;
                }
            }
            ++i;
        }
        GL11.glFrontFace(2304);
        GL11.glStencilOp(7680, 7680, 7683);
        i = 0;
        while (i < o.nPlanes) {
            if (o.planes[i].visible) {
                j = 0;
                while (j < 3) {
                    k = o.planes[i].neigh[j];
                    if (k != 0 || !o.planes[k - 1].visible) {
                        p1 = o.planes[i].p[j];
                        jj = (j + 1) % 3;
                        p2 = o.planes[i].p[jj];
                        v1.x = (o.points[p1].x - lp[0]) * 100.0f;
                        v1.y = (o.points[p1].y - lp[1]) * 100.0f;
                        v1.z = (o.points[p1].z - lp[2]) * 100.0f;
                        v2.x = (o.points[p2].x - lp[0]) * 100.0f;
                        v2.y = (o.points[p2].y - lp[1]) * 100.0f;
                        v2.z = (o.points[p2].z - lp[2]) * 100.0f;
                        GL11.glBegin(5);
                        GL11.glVertex3f(o.points[p1].x, o.points[p1].y, o.points[p1].z);
                        GL11.glVertex3f(o.points[p1].x + v1.x, o.points[p1].y + v1.y, o.points[p1].z + v1.z);
                        GL11.glVertex3f(o.points[p2].x, o.points[p2].y, o.points[p2].z);
                        GL11.glVertex3f(o.points[p2].x + v2.x, o.points[p2].y + v2.y, o.points[p2].z + v2.z);
                        GL11.glEnd();
                    }
                    ++j;
                }
            }
            ++i;
        }
        GL11.glFrontFace(2305);
        GL11.glColorMask(true, true, true, true);
        GL11.glColor4f(0.0f, 0.0f, 0.0f, 0.4f);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glStencilFunc(517, 0, -1);
        GL11.glStencilOp(7680, 7680, 7680);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glBegin(5);
        GL11.glVertex3f(-0.1f, 0.1f, -0.1f);
        GL11.glVertex3f(-0.1f, -0.1f, -0.1f);
        GL11.glVertex3f(0.1f, 0.1f, -0.1f);
        GL11.glVertex3f(0.1f, -0.1f, -0.1f);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glDisable(3042);
        GL11.glDepthFunc(515);
        GL11.glDepthMask(true);
        GL11.glEnable(2896);
        GL11.glDisable(2960);
        GL11.glShadeModel(7425);
    }
}

