/*
 * Decompiled with CFR 0.152.
 */
package opengl;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;

public class openglfont {
    Font font;
    String fontName = "Verdana";
    int fontSize = 12;
    BufferedImage fontImage;
    int[] charwidths = new int[256];
    private static final Color OPAQUE_WHITE = new Color(-1, true);
    private static final Color TRANSPARENT_BLACK = new Color(0, true);
    int bitmapSize = 512;
    int texture;

    public openglfont() {
        this.font = new Font(this.fontName, 0, this.fontSize);
        this.fontImage = new BufferedImage(this.bitmapSize, this.bitmapSize, 6);
        Graphics2D g = (Graphics2D)this.fontImage.getGraphics();
        g.setFont(this.font);
        g.setColor(OPAQUE_WHITE);
        g.setBackground(TRANSPARENT_BLACK);
        FontMetrics fm = g.getFontMetrics();
        int i = 0;
        while (i < 256) {
            int x = i % 16;
            int y = i / 16;
            char[] ch = new char[]{(char)i};
            String temp = new String(ch);
            g.drawString(temp, x * 32 + 1, y * 32 + fm.getAscent());
            this.charwidths[i] = fm.stringWidth(temp);
            ++i;
        }
        ByteBuffer scratch = ByteBuffer.allocateDirect(4 * this.fontImage.getWidth() * this.fontImage.getHeight());
        byte[] data = (byte[])this.fontImage.getRaster().getDataElements(0, 0, this.fontImage.getWidth(), this.fontImage.getHeight(), null);
        scratch.clear();
        scratch.put(data);
        scratch.rewind();
        IntBuffer buf = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
        GL11.glGenTextures(buf);
        GL11.glBindTexture(3553, buf.get(0));
        GL11.glTexParameteri(3553, 10241, 9729);
        GL11.glTexParameteri(3553, 10240, 9729);
        GL11.glTexImage2D(3553, 0, 6408, this.fontImage.getWidth(), this.fontImage.getHeight(), 0, 6408, 5121, scratch);
        this.texture = buf.get(0);
    }

    void drawchar(int whichchar, int posx, int posy, int width, int height) {
        float onechar = 0.0625f;
        float x = (float)(whichchar - whichchar / 16 * 16) * onechar;
        float y = (float)(whichchar / 16) * onechar;
        GL11.glTexCoord2f(x, y);
        GL11.glVertex2i(posx, posy);
        GL11.glTexCoord2f(x + onechar, y);
        GL11.glVertex2i(posx + width, posy);
        GL11.glTexCoord2f(x + onechar, y + onechar);
        GL11.glVertex2i(posx + width, posy + height);
        GL11.glTexCoord2f(x, y + onechar);
        GL11.glVertex2i(posx, posy + height);
    }

    public void print(int posx, int posy, String msg) {
        int width = 32;
        int height = 32;
        GL11.glBlendFunc(770, 771);
        GL11.glEnable(3042);
        GL11.glEnable(3553);
        GL11.glBindTexture(3553, this.texture);
        GL11.glBegin(7);
        int i = 0;
        while (i < msg.length()) {
            this.drawchar(msg.charAt(i), posx, posy, width, height);
            posx += this.charwidths[msg.charAt(i)];
            ++i;
        }
        GL11.glEnd();
        GL11.glDisable(3553);
    }
}

