/*
 * Decompiled with CFR 0.152.
 */
package g3d;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;

public class g3d_vertex {
    public float posx;
    public float posy;
    public float posz;
    static g3d_vertex temp = new g3d_vertex();

    public float getlength() {
        return (float)Math.sqrt(this.posx * this.posx + this.posy * this.posy + this.posz * this.posz);
    }

    public g3d_vertex(float x, float y, float z) {
        this.posx = x;
        this.posy = y;
        this.posz = z;
    }

    public void set(float x, float y, float z) {
        this.posx = x;
        this.posy = y;
        this.posz = z;
    }

    public g3d_vertex() {
        this.posx = 0.0f;
        this.posy = 0.0f;
        this.posz = 0.0f;
    }

    public void draw() {
        GL11.glDisable(3042);
        GL11.glDisable(2929);
        GL11.glDisable(2896);
        GL11.glDisable(3553);
        GL11.glPointSize(4.0f);
        GL11.glColor3f(1.0f, 1.0f, 0.0f);
        GL11.glBegin(0);
        GL11.glVertex3f(this.posx, this.posy, this.posz);
        GL11.glEnd();
    }

    public void glVertex() {
        GL11.glVertex3f(this.posx, this.posy, this.posz);
    }

    public void glColor() {
        GL11.glColor3f(this.posx, this.posy, this.posz);
    }

    public void glTranslate() {
        GL11.glTranslatef(this.posx, this.posy, this.posz);
    }

    public void glNormal() {
        GL11.glNormal3f(this.posx, this.posy, this.posz);
    }

    public FloatBuffer asFloatBuffer4Fdividedby2() {
        FloatBuffer tempFloatBuffer = null;
        if (tempFloatBuffer == null) {
            tempFloatBuffer = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        tempFloatBuffer.rewind();
        tempFloatBuffer.put(new float[]{this.posx / 2.0f, this.posy / 2.0f, this.posz / 2.0f, 0.0f}).flip();
        return tempFloatBuffer;
    }

    public FloatBuffer asFloatBuffer4F() {
        FloatBuffer tempFloatBuffer = null;
        if (tempFloatBuffer == null) {
            tempFloatBuffer = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        tempFloatBuffer.rewind();
        tempFloatBuffer.put(new float[]{this.posx, this.posy, this.posz, 0.0f}).flip();
        return tempFloatBuffer;
    }

    public static g3d_vertex add(g3d_vertex a, g3d_vertex b) {
        g3d_vertex.temp.posx = a.posx + b.posx;
        g3d_vertex.temp.posy = a.posy + b.posy;
        g3d_vertex.temp.posz = a.posz + b.posz;
        return temp;
    }

    public static g3d_vertex sub(g3d_vertex a, g3d_vertex b) {
        g3d_vertex.temp.posx = a.posx - b.posx;
        g3d_vertex.temp.posy = a.posy - b.posy;
        g3d_vertex.temp.posz = a.posz - b.posz;
        return temp;
    }

    public static g3d_vertex mul(g3d_vertex v, float f) {
        g3d_vertex.temp.posx = v.posx * f;
        g3d_vertex.temp.posy = v.posy * f;
        g3d_vertex.temp.posz = v.posz * f;
        return temp;
    }

    public static g3d_vertex cross(g3d_vertex a, g3d_vertex other) {
        float xh = a.posy * other.posz - other.posy * a.posz;
        float yh = a.posz * other.posx - other.posz * a.posx;
        float zh = a.posx * other.posy - other.posx * a.posy;
        g3d_vertex.temp.posx = xh;
        g3d_vertex.temp.posy = yh;
        g3d_vertex.temp.posz = zh;
        return temp;
    }
}

