/*
 * Decompiled with CFR 0.152.
 */
package g3d;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class g3d_quat {
    public float x;
    public float y;
    public float z;
    public float w;
    boolean tcb = false;
    int timeValue;
    private float xx;
    private float xy;
    private float xz;
    private float xw;
    private float yy;
    private float yz;
    private float yw;
    private float zz;
    private float zw;
    private float[] pMatrix = new float[16];

    public void normalize() {
        float n = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        if (n != 1.0f) {
            n = 1.0f / (float)Math.sqrt(n);
            this.x *= n;
            this.y *= n;
            this.z *= n;
            this.w *= n;
        }
    }

    public void setMatrix(float transx, float transy, float transz) {
        float x2 = this.x + this.x;
        float y2 = this.y + this.y;
        float z2 = this.z + this.z;
        float xx = this.x * x2;
        float xy = this.x * y2;
        float xz = this.x * z2;
        float yy = this.y * y2;
        float yz = this.y * z2;
        float zz = this.z * z2;
        float wx = this.w * x2;
        float wy = this.w * y2;
        float wz = this.w * z2;
        this.pMatrix[0] = 1.0f - (yy + zz);
        this.pMatrix[1] = xy - wz;
        this.pMatrix[2] = xz + wy;
        this.pMatrix[3] = transx;
        this.pMatrix[4] = xy + wz;
        this.pMatrix[5] = 1.0f - (xx + zz);
        this.pMatrix[6] = yz - wx;
        this.pMatrix[7] = transy;
        this.pMatrix[8] = xz - wy;
        this.pMatrix[9] = yz + wx;
        this.pMatrix[10] = 1.0f - (xx + yy);
        this.pMatrix[11] = transz;
        this.pMatrix[12] = 0.0f;
        this.pMatrix[13] = 0.0f;
        this.pMatrix[14] = 0.0f;
        this.pMatrix[15] = 1.0f;
        float[] m = new float[16];
        int j = 0;
        while (j < 4) {
            int i = 0;
            while (i < 4) {
                m[j * 4 + i] = this.pMatrix[i * 4 + j];
                ++i;
            }
            ++j;
        }
        FloatBuffer fb = BufferUtils.createFloatBuffer(16);
        int a = 0;
        while (a < 16) {
            fb.put(m[a]);
            ++a;
        }
        fb.flip();
        GL11.glMultMatrix(fb);
    }

    public static g3d_quat slerp(g3d_quat qa, g3d_quat qb, float t) {
        g3d_quat qm = new g3d_quat();
        float cosHalfTheta = qa.w * qb.w + qa.x * qb.x + qa.y * qb.y + qa.z * qb.z;
        if ((double)Math.abs(cosHalfTheta) >= 1.0) {
            qm.w = qa.w;
            qm.x = qa.x;
            qm.y = qa.y;
            qm.z = qa.z;
            return qm;
        }
        float halfTheta = (float)Math.acos(cosHalfTheta);
        float sinHalfTheta = (float)Math.sqrt(1.0 - (double)(cosHalfTheta * cosHalfTheta));
        if ((double)sinHalfTheta < 0.001) {
            qm.w = qa.w * 0.5f + qb.w * 0.5f;
            qm.x = qa.x * 0.5f + qb.x * 0.5f;
            qm.y = qa.y * 0.5f + qb.y * 0.5f;
            qm.z = qa.z * 0.5f + qb.z * 0.5f;
            return qm;
        }
        float ratioA = (float)Math.sin((1.0f - t) * halfTheta) / sinHalfTheta;
        float ratioB = (float)Math.sin(t * halfTheta) / sinHalfTheta;
        qm.w = qa.w * ratioA + qb.w * ratioB;
        qm.x = qa.x * ratioA + qb.x * ratioB;
        qm.y = qa.y * ratioA + qb.y * ratioB;
        qm.z = qa.z * ratioA + qb.z * ratioB;
        return qm;
    }

    public float norm() {
        return this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
    }
}

