float4x4 matView;
float4x4 matViewProjection;

float3 CameraPosition = {1.f, 1.f, 1.f};
float3 Light1 = (0.f, 0.f, 0.f);
float3 Light2 = (0.f, 0.f, 0.f);
float3 Light3 = (0.f, 0.f, 0.f);
float3 Light4 = (0.f, 0.f, 0.f);
float3 Light5 = (0.f, 0.f, 0.f);
float3 Light6 = (0.f, 0.f, 0.f);

float2 fsize = {128.f, 128.f}; //forteller hvor store spritene er i texturen
float alpha = 1.f;
float FogEnd = 300.f;
float FogStart = 0.f;
float const_rot = 1.f;

float time; 

texture tex0;
sampler2D diffuse = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};

void vs_6ptfog(in float3 ipos : POSITION,
			   in float3 inorm : NORMAL, 
			   in float2 itex : TEXCOORD0,
				  out float4 opos : POSITION,
				  out float2 otex : TEXCOORD0,
				  out float  ialpha : TEXCOORD1,
				  out float3  fog1 : TEXCOORD2,
				  out float3  fog2 : TEXCOORD3)
{
	//here we get our data
	float size      =   inorm.x;     
	ialpha    =   inorm.y;
	int   type      =   (int)inorm.z;   
	float rotation  =   frac(inorm.z)*const_rot*time; 
	

	//ipos.y = 60.f*sin( (ipos.y/40)*1.2f);
	ipos += float3(matView._11, matView._21, matView._31)*itex.x*size;
	ipos += float3(matView._12, matView._22, matView._32)*itex.y*size;
	opos = mul(float4(ipos, 1.f), matViewProjection);

	
	//setup a rotation matrix	
	float rx = sin(rotation);
	float ry = cos(rotation);
	float2x2 matTex = {ry, -rx,
					   rx, ry};

	//make coords
	otex = mul(itex, matTex);
	otex += .5f;

	//makeout the row/col of the char
	float row = floor(type/8.f);
	float col = type-(row*8.f);
	
	//convert to texcoords
	otex.x = col*(fsize.x/1024.f) + otex.x*(fsize.x/1024.f);
	otex.y = row*(fsize.y/640.f)  + otex.y*(fsize.y/640.f);
	
	
	//let's fog
	//fog = 1.f-clamp( (length(CameraPosition-(ipos))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
	fog1.x = 1.f-clamp( (length(Light1-(ipos))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
	fog1.y = 1.f-clamp( (length(Light2-(ipos))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
	fog1.z = 1.f-clamp( (length(Light3-(ipos))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);

	fog2.x = 1.f-clamp( (length(Light4-(ipos))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
	fog2.y = 1.f-clamp( (length(Light5-(ipos))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
	fog2.z = 1.f-clamp( (length(Light6-(ipos))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);

}

float4 ps_6ptfog(in float2 tex : TEXCOORD0,		
				 in float ialpha : TEXCOORD1,
				 in float3 fog1 : TEXCOORD2,
				 in float3 fog2 : TEXCOORD3) : COLOR0
{
	float4 a = tex2D(diffuse, tex);
	
	float fogconst = fog1.x+fog1.y+fog1.z+fog2.x+fog2.y+fog2.z;
	//float4 b = (a*fog1.x)+(a*fog1.y)+(a*fog1.z); 
	return a*fogconst*alpha;
}


technique Partikkel
{
	pass sixptfog
	{
		VertexShader = compile vs_2_0 vs_6ptfog();
		PixelShader  = compile ps_2_0 ps_6ptfog();
	}
}