float4x4 matWorldViewProjection;

texture tex0;
texture tex1;
texture tex2;
texture tex3;

sampler2D t0 = sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

sampler2D t1 = sampler_state
{
	texture = (tex1);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

sampler2D t2 = sampler_state
{
	texture = (tex2);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

sampler2D t3 = sampler_state
{
	texture = (tex3);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

void vs_plain(in float4 ipos : POSITION,
			  in float2 itex : TEXCOORD0,
			  out float4 opos : POSITION,
			  out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
};

float4 ps_exp(in float2 tex : TEXCOORD0 ) : COLOR0
{
	float4 s = pow(tex2D(t0, tex), 1.5f);
	float4  a = tex2D(t1, tex);
	float4  b = tex2D(t2, tex);
	float4  c = tex2D(t3, tex);

	//return s; 
	//return b;
	return saturate( a*s.r + b*s.g + c*s.b);
};

technique exprimental
{
	pass yo
	{
		vertexshader = compile vs_2_0 vs_plain(); 
		pixelshader  = compile ps_2_0 ps_exp(); 
	}
}