{
  Defjamz article compiler, (c) Grant Passmore (skaboy101) 1998

  This program will take either straight ascii text or binary imagery
  and compile them into the defjamz article database / article index.

  If you have any questions on adding more conversions (ie, pipe codes,
  ansi, etc) lemme know, and I will do it for you.

  If this code is used or implemented in one of your applications, please
  give me greets or credit, that is all I ask :)

  -skaboy (grant passmore)
   skaboy101@mindless.com
   http://avenge.razorshift.com

}
program defjamzCompiler;
 uses crt,dos,extense,records;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
procedure sInitMem(init : boolean);
 begin
  if init then
   begin
   new(sIndexData);
   new(sArticleData);
   fillChar(sIndexData^,sizeOf(sIndexData^),0);
   fillChar(sArticleData^,sizeOf(sArticleData^),0);
   end else
    begin
    dispose(sIndexData);
    dispose(sArticleData);
    end;
 end;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
procedure sDrawScreens(scrn : byte);
 var x : byte;
 begin
  if (scrn=1) then
   begin
   textAttr := 7;
   clrscr;
   pipeWrite('|16|08-- |15Defjamz Article Importer (c) Copyright Skaboy101 (Grant Passmore) 1998'#13#10);
   pipeWrite('|16|08-- |07Property of Grant Passmore / Defjamz Crew, and no one else, chump.'#13#10);
   for x := 1 to 80 do pipeWrite('|08'#196);
   end else
  if (scrn=2) then
   begin
   pipeWrite('|16|08-- |07Valid usage is '+paramStr(0)+' <fileType> <fileName>'#13#10);
   pipeWrite('|16|07   |07Filetype can be either (1/Ascii Text) (2/Raw Binary Screen)'#13#10);
   halt(5);
   end else
  if (scrn=3) then
   begin
   pipeWrite('|16|08-- |07Error..'#13#10);
   pipeWrite('|16|07   |07The bin must still be saved in fullwidth (ie, fileSize MOD 160 = 0)'#13#10);
   pipeWrite('|16|07   |07Please do this and run this application again..'#13#10);
   halt(5);
   end;
 end;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
function exist(fileName : string) : boolean; assembler;
 asm
  push ds; lds si,fileName; xor bx,bx; mov bl,[si]; inc si; mov dx,si;
  mov [si+bx],bh; mov ax,4300h; int 21h; mov al,bh; adc cl,cl; and cl,31h;
  jnz @@done; inc al; @@done: pop ds
 end;
{::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
procedure sCheckCommandLine;
 begin
 sDrawScreens(1);
 if (paramStr(1)<>'1') and (paramStr(1)<>'2') then
     sDrawScreens(2);
 if not exist(paramStr(2)) then sDrawScreens(2);
 end;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
procedure sImportText;
var sInFile   : text;
    sTempChar : char;
    sCount    : byte;
 begin
 assign(sInFile,paramStr(2));
 reset(sInfile);
 fillChar(sArticleData^.lineData,sizeOf(sArticleData^.lineData),0);
 sCount := 1;
  repeat
  read(sInFile,sTempChar);
  if (sTempChar in [#13,#10]) or (sCount>=160) then
   begin
   if (sTempChar<>#10) then
    begin
    blockWrite(sDataFile,sArticleData^.lineData,sizeOf(sArticleData^.lineData));
    inc(sIndexData^.artLines);
    fillChar(sArticleData^.lineData,sizeOf(sArticleData^.lineData),0);
    sCount := 1;
    end;
   end else
    begin
    sArticleData^.lineData[sCount] := sTempChar;
    sArticleData^.lineData[sCount+1] := #7;
    inc(sCount,2);
    end;
  until eof(sInFile);
 end;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
procedure sImportBinary;
var inFile : file;
 begin
 assign(inFile,paramStr(2));
 reset(inFile,1);
 if ((fileSize(inFile) mod 160)<>0) then
  begin
  close(inFile);
  sDrawScreens(3);
  end;
 sIndexData^.artLines := fileSize(inFile) div 160;
 repeat
 blockRead(inFile,sArticleData^.lineData,160);
 blockWrite(sDataFile,sArticleData^.lineData,160);
 until eof(inFile);
 close(inFile);
 end;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
procedure sImportFile;
 begin
 assign(sIndexFile,sIdxFileName);
 assign(sDataFile,sDataFileName);
 if not exist(sIdxFileName) then rewrite(sIndexFile,1) else
        reset(sIndexFile,1);
 if not exist(sDataFileName) then rewrite(sDataFile,1) else
        reset(sDataFile,1);
 seek(sIndexFile,fileSize(sIndexFile));
 seek(sDataFile,fileSize(sDataFile));
 sIndexData^.idNum    := (fileSize(sIndexFile) div sizeOf(sIndexDataRec))+1;
 sIndexData^.startPos := filePos(sDataFile);
 write('Enter Article Title: '); readLn(sIndexData^.artTitle);
 write('Enter Article Author: ');readLn(sIndexData^.artAuthor);
 if (paramStr(1)='1') then sImportText else
     sImportBinary;
 blockWrite(sIndexFile,sIndexData^,sizeOf(sIndexData^));
 close(sIndexFile);
 close(sDataFile);
 end;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
begin
 sInitMem(true);
 sCheckCommandLine;
 sImportFile;
 sInitMem(false);
end.


