{$A+,B-,D+,E+,F-,G+,I+,L+,N-,O-,P-,Q+,R+,S+,T-,V-,X+,Y+}

UNIT CRTVGA;    { Additional CRT functions and special VGA features used in AppGen }

{--------------------------------------------------------------------------------}
INTERFACE
{--------------------------------------------------------------------------------}

{ CRT Stuff }

{ Key values as returned by ScanKey, only the ones used in AppGen are listed }
CONST  KEY_Enter     = 13;
       KEY_Esc       = 27;
       KEY_Space     = 32;
       KEY_BackSpace = 8;
       KEY_Tab       = 9;            KEY_ShiftTab  = 256+15;

       KEY_Up        = 256+72;       KEY_Down      = 256+80;
       KEY_Left      = 256+75;       KEY_Right     = 256+77;
       KEY_PgUp      = 256+73;       KEY_PgDn      = 256+81;
       KEY_Home      = 256+71;       KEY_End       = 256+79;

       KEY_F1        = 256+59;       KEY_F2        = 256+60;
       KEY_F3        = 256+61;       KEY_F4        = 256+62;
       KEY_F5        = 256+63;       KEY_F6        = 256+64;
       KEY_F7        = 256+65;       KEY_F8        = 256+66;
       KEY_F9        = 256+67;       KEY_F10       = 256+68;

PROCEDURE WriteAt_Piped(X, Y : WORD; Txt : String);
FUNCTION  ScanKey : Integer;


{ Special VGA Stuff }

CONST  VGA_CRTC         = $03D4;       { Port address CRTC                   }
       VGA_STATUS       = $03DA;       { Port address for Status register    }
       VGA_AC           = $03C0;       { Port address Attribute controller   }
       VGA_AC_READ      = $03C1;       { Read address Attribute controller   }
       VGA_SR           = $03C4;       { Port address Sequencer register     }
       VGA_GC           = $03CE;       { Port address Graphics controller    }
       VGA_PEL_WRITE    = $03C8;       { Port address PEL Address Write      }
       VGA_PEL_READ     = $03C7;       { Port address PEL Address Read       }
       VGA_PEL_DATA     = $03C9;       { Port address PEL Data register      }

VAR    VGA_Memory : ARRAY[0..32*1024-1] OF BYTE Absolute $B800:0000;
       ORG_Memory : ARRAY[1..25,1..80] of WORD;
       ORG_X      : INTEGER;
       ORG_Y      : INTEGER;

FUNCTION  VGA_IsPresent     : BOOLEAN;
PROCEDURE VGA_Set8PixelFont;
PROCEDURE VGA_VSync;
PROCEDURE VGA_PixelPan(VidOffset, PixelPan : WORD);
PROCEDURE VGA_Split(VidOffset, SplitAt : WORD);

{--------------------------------------------------------------------------------}
IMPLEMENTATION
{--------------------------------------------------------------------------------}

USES CRT;


PROCEDURE WriteAT_Piped(X, Y : WORD; Txt : String); ASSEMBLER;
ASM
              PUSH   DS                { Save DS, we'll be changing it     }

              CLD                      { Increment on Lods/Stos            }
              LDS    SI,Txt            { DS:SI -> String                   }
              LODSB                    { Load first byte (=string length)  }
              XOR    AH,AH             { Clear upper byte                  }
              MOV    CX,AX             { Copy in CX                        }
              JCXZ   @EndWrite         { Length zero ?  Quit now           }

              MOV    BX,80             { BX=80                             }
              MOV    AX,Y              { AX=Y                              }
              DEC    AX                { AX=(Y-1)                          }
              MUL    BX                { AX=(Y-1)*80                       }
              ADD    AX,X              { AX=(Y-1)*80+X                     }
              DEC    AX                { AX=(Y-1)*80+(X-1)                 }
              SHL    AX,1              { AX=(Y-1)*160+(X-1)*2, addres X,Y  }

              MOV    DI,0B800h         { >ES:DI -> Video memory word of   }
              MOV    ES,DI             {           X,Y                    }
              MOV    DI,AX             {                                  }

              MOV    AH,7              { AH=07 default attribute           }
@WriteLoop:   LODSB                    { Load string character in AL       }
              CMP    AL,'|'            { Is it the Pipe character ?        }
              JE     @IsPipe           { No, write character               }
              STOSW                    { Store character+attribute in AX   }
              LOOP   @WriteLoop        { One done, loop if more to do      }
              JMP    @EndWrite         { DONE                              }

              { Translate following 2 hex chars to a value in AH }
@IsPipe:      SUB    CX,2              { We need 2 characters              }
              JLE    @EndWrite         {  there aren't 2 anymore. Bail out }
              XOR    AH,AH             { Zero out AH first.                }
              LODSB                    { Load 1st Hex char 0123456789ABCDEF}
              CMP    AL,'A'            { AL<'A' (Assume '0'-'9')           }
              JB     @IsDec1           {  Yes, then we're done             }
              ADD    AL,-'A'+'9'+1     { AL ['A'..'F'] to ['9'+1..'9'+6]   }
@IsDec1:      SUB    AL,'0'            { '0'->0, '9'->9, '9'+1->10...      }
              MOV    AH,AL             { Copy in AH                        }
              SHL    AH,1              { >Move to upper nibble            }
              SHL    AH,1              {                                  }
              SHL    AH,1              {                                  }
              SHL    AH,1              {                                  }
              LODSB                    { Load 2nd Hex char 0123456789ABCDEF}
              CMP    AL,'A'            { AL<'A' (Assume '0'-'9')           }
              JB     @IsDec2           {  Yes, then we're done             }
              ADD    AL,-'A'+'9'+1     { AL ['A'..'F'] to ['9'+1..'9'+6]   }
@IsDec2:      SUB    AL,'0'            { '0'->0, '9'->9, '9'+1->10...      }
              OR     AH,AL             { Copy lower nibble into AH         }
              LOOP   @WriteLoop        { And continue                      }

@EndWrite:    POP    DS                { Restore DS                        }
END;

FUNCTION  ScanKey : Integer;    { Scan a key, return negative values for special keys }
VAR Ch : Char;
BEGIN
  Ch:=ReadKey;
  IF (ch=#0) THEN
     ScanKey := 256+Ord(ReadKey)
  ELSE
     ScanKey := Ord(Ch);
END;

{===========================================================================}

{ RETURN TRUE if VGA card is present }
FUNCTION  VGA_IsPresent : BOOLEAN; ASSEMBLER;
ASM
              MOV    AX,01A00h         { > Display Combination Code       }
              INT    10h               {                                  }
              CMP    AL,01Ah           { Is AL=01Ah then it's a VGA        }
              MOV    AL,TRUE           { Assume it'll be true              }
              JE     @Return           { We were right, quit now           }
              MOV    AL,FALSE          { We were wrong, return false       }
@Return:
END;

PROCEDURE VGA_Set8PixelFont; ASSEMBLER;
ASM
              MOV    DX,003CCh         { Misc output register READ port    }
              IN     AL,DX             { Read value.                       }
              AND    AL,0F3h           { Bits 2 & 3 off (Clock select 0).  }
              MOV    DX,003C2h         { Misc Output Write port            }
              OUT    DX,AL             { Writeback modified value          }

              CLI                      { NO interrupts for a while         }
              MOV    DX,03C4h          { Sequencer register                }
              MOV    AX,100h           { >Generate and hold Synchronous   }
              OUT    DX,AX             {  reset                           }

              MOV    AL,001h           { Clocking mode register            }
              OUT    DX,AL             { Activate Clocking mode register   }
              INC    DX                { Data register                     }
              IN     AL,DX             { Read value                        }
              OR     AL,1              { Set Bit 0 (8/9)                   }
              OUT    DX,AL             { Writeback.                        }
              DEC    DX                { Back to Address register          }

              MOV    AX,300h           { \ Release Reset state. (normal)   }
              OUT    DX,AX             { /                                 }

              MOV    DX,VGA_STATUS     { CRTC Status register              }
              IN     AL,DX             { Read CRTC Status. (This'll reset  }
                                       { Attribute controller flip-flop)   }
              MOV    DX,VGA_AC         { Attribute controller              }
              MOV    AL,13h            { Horizontal Pixel Pan              }
              OUT    DX,AL             { Activate HPP                      }
              MOV    AL,0              { \ Set HPP to 0                    }
              OUT    DX,AL             { /                                 }
              MOV    AL,20h
              OUT    DX,AL             { Set PAS field (Video has access   }
                                       { to palette)                       }

              STI                      { Interrupts allowed again          }
END;

PROCEDURE VGA_VSync; ASSEMBLER;
ASM
              MOV    DX,VGA_Status      { CRTC Status Register             }
@VS_End_Loop: IN     AL,DX              { Get status byte                  }
              AND    AL,008h            { Mask VSync bit                   }
              JNZ    @VS_End_Loop       { If not VSync END, try again      }
@VS_Beg_Loop: IN     AL,DX              { Get status byte                  }
              AND    AL,008h            { Mask VSync bit                   }
              JZ     @VS_Beg_Loop       { if not VSync BEGIN, try again    }
END;

PROCEDURE VGA_PixelPan(VidOffset, PixelPan : WORD); ASSEMBLER;
ASM
              MOV    BX,[VidOffset]     { BH = High part, BL = Low part    }
              MOV    CH,BL              { CH = Low Part                    }
              MOV    BL,0Ch             { BX, value for Start address High }
              MOV    CL,0Dh             { CX, value for Start address Low  }

              MOV    DX,VGA_Status
@WaitDE:      IN     AL,DX
              TEST   AL,01h
              JNZ    @WaitDE            { Display enable is active         }
                                        { low (0 = active)                 }
{ Set the start offset in display memory of the page to display. }
              CLI
              MOV    DX,VGA_CRTC
              MOV    AX,BX
              OUT    DX,AX              { Start address High               }
              MOV    AX,CX
              OUT    DX,AX              { Start address low                }
{ set pixel panning }
              MOV    DX,VGA_AC          { Attribute controller             }
              MOV    AL,13h OR 20h      { Horizontal Pixel Pan, Display    }
                                        {   Display accesses palette       }
              OUT    DX,AL              { Set register.  Adress flip-flop  }
                                        { was reset in FlipPage            }
              MOV    AX,PixelPan        { Value for Horizontal Pixel Pan   }
              OUT    DX,AL              { And Write to port.               }
              STI

{ Now wait for vertical sync, for changes to become visible                }
              MOV    DX,VGA_Status
@VS_Beg_Loop: IN     AL,DX              { Get status byte                  }
              AND    AL,008h            { Mask VSync bit                   }
              JZ     @VS_Beg_Loop       { if not VSync BEGIN, try again    }
END;

PROCEDURE VGA_Split(VidOffset, SplitAt : WORD); ASSEMBLER;
ASM
              MOV    DI,SplitAt         {                                 }
              OR     DI,DI              { >Split at 0 ?  Disable          }
              JNZ    @SplitOK           {  splitscreen                    }
              MOV    DI,1023            {                                 }
@SplitOK:     MOV    BX,VidOffset       { BH = High part, BL = Low part    }
              MOV    CH,BL              { CH = Low Part                    }
              MOV    BL,0Ch             { BX, value for Start address High }
              MOV    CL,0Dh             { CX, value for Start address Low  }

              MOV    DX,VGA_Status
@WaitDE:      IN     AL,DX
              TEST   AL,01h
              JNZ    @WaitDE            { Display enable is active         }
                                        { low (0 = active)                 }
{ Set the start offset in display memory of the page to display. }
              CLI
              MOV    DX,VGA_CRTC
              MOV    AX,BX
              OUT    DX,AX              { Start address High               }
              MOV    AX,CX
              OUT    DX,AX              { Start address low                }

{ Now wait for vertical sync, for changes to become visible                }
              MOV    DX,VGA_Status
@VS_Beg_Loop: IN     AL,DX              { Get status byte                  }
              AND    AL,008h            { Mask VSync bit                   }
              JZ     @VS_Beg_Loop       { if not VSync BEGIN, try again    }

{ set split screen }
              MOV    AX,DI              { Where to split                   }
              MOV    DX,VGA_CRTC        { CRTC register                    }
              MOV    BL,AH              { >BL = BIT 8 of Line Compare     }
              AND    BL,001b            {                                 }
              MOV    BH,AH              { >BH = BIT 9 of line Compare     }
              AND    BH,010b            {                                 }
              SHL    BX,1               {                                 }
              SHL    BX,1               { >BIT 8 of Line compare is in bit}
              SHL    BX,1               {   4 of Overflow register (in BL)}
              SHL    BX,1               {                                 }
              SHL    BH,1               { Bit 9 of LC in Bit 6 of Max Scanline }

              MOV    AH,AL              { Bits 0-7 of LC                   }
              MOV    AL,18h             { LC register                      }
              OUT    DX,AX

              MOV    AL,7               { Overflow register                }
              OUT    DX,AL              { Activate overflow register       }
              INC    DX                 { DX = dataport of CRTC            }
              IN     AL,DX              { Read what's there                }
              AND    AL,011101111b      { BIT 4 = 0                        }
              OR     AL,BL              { Set bit 8 of LC                  }
              OUT    DX,AL              { update overflow register         }
              DEC    DX                 { back to addressport of CRTC      }

              MOV    AL,9               { Maximum scanline register        }
              OUT    DX,AL              { Activate overflow register       }
              INC    DX                 { DX = dataport of CRTC            }
              IN     AL,DX              { Read what's there                }
              AND    AL,010111111b      { BIT 6 = 0                        }
              OR     AL,BH              { Set bit 9 of LC                  }
              OUT    DX,AL              { update Maximum scanline register }
              DEC    DX                 { back to addressport of CRTC      }

              STI
END;

BEGIN
  Move(VGA_Memory, ORG_Memory, sizeof(ORG_Memory));
  ORG_X:=WhereX;
  ORG_Y:=WhereY;
END.
