Unit AF_PDemo;     { Loader/Demo programmer information }

{--------------------------------------------------------------------------------}
INTERFACE
{--------------------------------------------------------------------------------}

{           1         2         3         4         5         6         7         8
   12345678901234567890123456789012345678901234567890123456789012345678901234567890
 5|                                        Years Coding : [...]
 6|               Number of programs produced (approx.) : [....]
 7|    How much time does it take you to code something : [......................]
 8| How often can you produce a loader or demo for ACiD : [......................]
 9|   How small can you usually crunch a loader or demo : [......................]
 0|     What video modes can you code in (320x200, etc) : [......................]
11|
12|What programming languages are you fluent in :
13|[.............................................................................]
14|[.............................................................................]
15|
16|What kind of effects can you code (Scrolling, Morphing, Vectors, etc) :
17|[.............................................................................]
18|[.............................................................................]
19|[.............................................................................]
20|
21|Additional Comments :
22|[.............................................................................]
23|[.............................................................................]
}

FUNCTION  Entry(Page, NumPages, Direction : Integer) : Integer;
PROCEDURE Store(VAR Out: Text);

{--------------------------------------------------------------------------------}
IMPLEMENTATION
{--------------------------------------------------------------------------------}

USES  CRTVGA,
      Support,
      TOTFast, TOTIO1, TOTIO2, TOTIO3, TOTInput, TOTStr;

TYPE  FormType = RECORD
                Years      : PictureIOOBJ;
                TotPrograms: PictureIOOBJ;
                Time       : LateralIOOBJ;
                HowOften   : LateralIOOBJ;
                HowSmall   : LateralIOOBJ;
                VideoModes : LateralIOOBJ;
                Languages1 : LateralIOOBJ;
                Languages2 : LateralIOOBJ;
                Effects1   : LateralIOOBJ;
                Effects2   : LateralIOOBJ;
                Effects3   : LateralIOOBJ;
                Comments1  : LateralIOOBJ;
                Comments2  : LateralIOOBJ;
              END;
VAR   Form         : ^FormType;
      SaveExitProc : POINTER;



{$L APP_DEMO.OBJ}
PROCEDURE APP_DEMO; External;


FUNCTION Entry(Page, NumPages, Direction : Integer) : Integer;
VAR   Manager     : FormOBJ;
      Result      : tAction;
      UpKey,
      DownKey,
      TabKey,
      ShiftTabKey,
      EnterKey,
      PgDnKey,
      PgUpKey,
      F10Key      : HotKeyIOOBJ;

BEGIN
  { Initialize (construct) Objects Entry }
  Manager.Init;
  UpKey.Init      (KEY_Up,      PrevField);
  DownKey.Init    (KEY_Down,    NextField);
  EnterKey.Init   (KEY_Enter,   NextField);
  TabKey.Init     (KEY_Tab,     NextField);
  ShiftTabKey.Init(KEY_ShiftTab,PrevField);
  PgUpKey.Init    (KEY_PgUp,    Stop1);
  PgDnKey.Init    (KEY_PgDn,    Stop2);
  F10Key.Init     (KEY_F10,     Stop3);

  { Show Form Screen }
  SlideForm(@APP_DEMO, Page, NumPages, Direction);

  WITH Manager DO BEGIN
     { Add special keys }
     AddItem(UpKey);
     AddItem(DownKey);
     AddItem(EnterKey);
     AddItem(TabKey);
     AddItem(ShiftTabKey);
     IF (Page>1) THEN
        AddItem(PgUpKey);
     IF (Page<NumPages) THEN
        AddItem(PgDnKey);
     IF (Page=NumPages) THEN
        AddItem(F10Key);
     { Input items }
     AddItem(Form^.Years);
     AddItem(Form^.TotPrograms);
     AddItem(Form^.Time);
     AddItem(Form^.HowOften);
     AddItem(Form^.HowSmall);
     AddItem(Form^.VideoModes);
     AddItem(Form^.Languages1);
     AddItem(Form^.Languages2);
     AddItem(Form^.Effects1);
     AddItem(Form^.Effects2);
     AddItem(Form^.Effects3);
     AddItem(Form^.Comments1);
     AddItem(Form^.Comments2);
  END;

  { Do entry }
  Screen.CursOn;                      { Cursor on }
  IoTot^.SetColField(8, 15, 7, 8);    { Set color for fields. (Inactive field, Active field, Picture (non editable), Readonly }
  Result := Manager.Go;

  { What to do next }
  Case Result of
     Escaped : Entry:=0;
     Stop1   : Entry:=-1;
     Stop2   : Entry:=1;
     Stop3   : Entry:=10;
  END;

  { Dispose (destruct) objects }
  Manager.Done;
  UpKey.Done;
  DownKey.Done;
  EnterKey.Done;
  TabKey.Done;
  ShiftTabKey.Done;
  PgUpKey.Done;
  PgDnKey.Done;
  F10Key.Done;

  { Dirty trick.  Move on screen data back into linked screen.  This makes }
  { paging back to it look better                                          }
  Move(VGA_Memory, @APP_DEMO^, 4000);
END;


PROCEDURE Store(VAR Out: Text);
BEGIN
  WITH Form^ DO BEGIN
    Writeln(Out, '  ,-------------------------------------.');
    Writeln(Out, ',-'' Demo/Loader programmer Application  `-----------------------------------.');
    Writeln(Out, '|                                                                           |');
    Writeln(Out, '`---------------------------------------------------------------------------''');
    Writeln(Out, '');
    Writeln(Out, 'Years Coding                : ', Years.GetValue);
    Writeln(Out, 'Number of programs produced : ', TotPrograms.GetValue);
    Writeln(Out, 'How much time does it take to code a loader?      : ', Time.GetValue);
    Writeln(Out, 'How many programs can you produce in one month?   : ', HowOften.GetValue);
    Writeln(Out, 'How small can you usually crunch a loader? : ', HowSmall.GetValue);
    Writeln(Out, 'What video modes can you code in?          : ', VideoModes.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'What programming languages are you fluent in?');
    Writeln(Out, Languages1.GetValue);
    Writeln(Out, Languages2.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'What kind of effects can you code?: ');
    Writeln(Out, Effects1.GetValue);
    Writeln(Out, Effects2.GetValue);
    Writeln(Out, Effects3.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'Additional Comments:');
    Writeln(Out, Comments1.GetValue);
    Writeln(Out, Comments2.GetValue);
    Writeln(Out, '');
  END;
END;


{$F+} { Exitproc must be "far" }
PROCEDURE Cleanup;
BEGIN
  { Dispose (destruct) objects }
  WITH Form^ DO BEGIN
     Years.Done;
     TotPrograms.Done;
     Time.Done;
     HowOften.Done;
     HowSmall.Done;
     VideoModes.Done;
     Languages1.Done;
     Languages2.Done;
     Effects1.Done;
     Effects2.Done;
     Effects3.Done;
     Comments1.Done;
     Comments2.Done;
  END;

  Dispose(Form);

  { And revert to original ExitProc }
  ExitProc:=SaveExitProc;
END;
{$F-}


BEGIN
  New(Form);
  FillChar(Form^, sizeof(Form^), 0);

  { Install cleanup routine }
  SaveExitProc:= ExitProc;
  ExitProc:=@Cleanup;

  { One time initialization of Form }
  WITH Form^ DO BEGIN
     Years.Init(57, 5, '###');
     Years.SetPadChar('.');

     TotPrograms.Init(57, 6, '####');
     TotPrograms.SetPadChar('.');

     Time.Init(57, 7, 22, 50);
     Time.SetPadChar('.');

     HowOften.Init(57, 8, 22, 50);
     HowOften.SetPadChar('.');

     HowSmall.Init(57, 9, 22, 50);
     HowSmall.SetPadChar('.');

     VideoModes.Init(57, 10, 22, 50);
     VideoModes.SetPadChar('.');

     Languages1.Init(2, 13, 77, 77);
     Languages1.SetPadChar('.');

     Languages2.Init(2, 14, 77, 77);
     Languages2.SetPadChar('.');

     Effects1.Init(2, 17, 77, 77);
     Effects1.SetPadChar('.');

     Effects2.Init(2, 18, 77, 77);
     Effects2.SetPadChar('.');

     Effects3.Init(2, 19, 77, 77);
     Effects3.SetPadChar('.');

     Comments1.Init(2, 22, 77, 77);
     Comments1.SetPadChar('.');

     Comments2.Init(2, 23, 77, 77);
     Comments2.SetPadChar('.');

  END;
END.
