Unit AF_ISWEB;    { Web developer }

{--------------------------------------------------------------------------------}
INTERFACE
{--------------------------------------------------------------------------------}

{           1         2         3         4         5         6         7         8
   12345678901234567890123456789012345678901234567890123456789012345678901234567890
 5|                           Years designing web sites : [...]
 6|        Number of sites you have completed (approx.) : [....]
 7|      How long does it take you to finish a web site : [......................]
 8|   How often can you produce a site or page for ACiD : [......................]
 9|        What operating systems are you familiar with : [......................]
10|
11|What CGI programming and scripting languages are you fluent in :
12|[.............................................................................]
13|[.............................................................................]
14|
15|What sort of websites can you develop/wish to develop with ACiD :
16|[.............................................................................]
17|[.............................................................................]
18|[.............................................................................]
19|
20|Additional Comments :
21|[.............................................................................]
22|[.............................................................................]
23|[.............................................................................]
}

FUNCTION  Entry(Page, NumPages, Direction : Integer) : Integer;
PROCEDURE Store(VAR Out: Text);

{--------------------------------------------------------------------------------}
IMPLEMENTATION
{--------------------------------------------------------------------------------}

USES  CRTVGA,
      Support,
      TOTFast, TOTIO1, TOTIO2, TOTIO3, TOTInput, TOTStr;

TYPE   FormType = RECORD
                Years      : PictureIOOBJ;
                TotSites   : PictureIOOBJ;
                Time       : LateralIOOBJ;
                HowOften   : LateralIOOBJ;
                OS         : LateralIOOBJ;
                Languages1 : LateralIOOBJ;
                Languages2 : LateralIOOBJ;
                WebType1   : LateralIOOBJ;
                WebType2   : LateralIOOBJ;
                WebType3   : LateralIOOBJ;
                Comments1  : LateralIOOBJ;
                Comments2  : LateralIOOBJ;
                Comments3  : LateralIOOBJ;
              END;
VAR   Form         : ^FormType;
      SaveExitProc : POINTER;



{$L APP_WEB.OBJ}
PROCEDURE APP_WEB; External;


FUNCTION Entry(Page, NumPages, Direction : Integer) : Integer;
VAR   Manager     : FormOBJ;
      Result      : tAction;
      UpKey,
      DownKey,
      TabKey,
      ShiftTabKey,
      EnterKey,
      PgDnKey,
      PgUpKey,
      F10Key      : HotKeyIOOBJ;

BEGIN
  { Initialize (construct) Objects Entry }
  Manager.Init;
  UpKey.Init      (KEY_Up,      PrevField);
  DownKey.Init    (KEY_Down,    NextField);
  EnterKey.Init   (KEY_Enter,   NextField);
  TabKey.Init     (KEY_Tab,     NextField);
  ShiftTabKey.Init(KEY_ShiftTab,PrevField);
  PgUpKey.Init    (KEY_PgUp,    Stop1);
  PgDnKey.Init    (KEY_PgDn,    Stop2);
  F10Key.Init     (KEY_F10,     Stop3);

  { Show Form Screen }
  SlideForm(@APP_WEB, Page, NumPages, Direction);

  WITH Manager DO BEGIN
     { Add special keys }
     AddItem(UpKey);
     AddItem(DownKey);
     AddItem(EnterKey);
     AddItem(TabKey);
     AddItem(ShiftTabKey);
     IF (Page>1) THEN
        AddItem(PgUpKey);
     IF (Page<NumPages) THEN
        AddItem(PgDnKey);
     IF (Page=NumPages) THEN
        AddItem(F10Key);
     { Input items }
     AddItem(Form^.Years);
     AddItem(Form^.TotSites);
     AddItem(Form^.Time);
     AddItem(Form^.HowOften);
     AddItem(Form^.OS);
     AddItem(Form^.Languages1);
     AddItem(Form^.Languages2);
     AddItem(Form^.WebType1);
     AddItem(Form^.WebType2);
     AddItem(Form^.WebType3);
     AddItem(Form^.Comments1);
     AddItem(Form^.Comments2);
     AddItem(Form^.Comments3);
  END;

  { Do entry }
  Screen.CursOn;                      { Cursor on }
  IoTot^.SetColField(8, 15, 7, 8);    { Set color for fields. (Inactive field, Active field, Picture (non editable), Readonly }
  Result := Manager.Go;

  { What to do next }
  Case Result of
     Escaped : Entry:=0;
     Stop1   : Entry:=-1;
     Stop2   : Entry:=1;
     Stop3   : Entry:=10;
  END;

  { Dispose (destruct) objects }
  Manager.Done;
  UpKey.Done;
  DownKey.Done;
  EnterKey.Done;
  TabKey.Done;
  ShiftTabKey.Done;
  PgUpKey.Done;
  PgDnKey.Done;
  F10Key.Done;

  { Dirty trick.  Move on screen data back into linked screen.  This makes }
  { paging back to it look better                                          }
  Move(VGA_Memory, @APP_WEB^, 4000);
END;


PROCEDURE Store(VAR Out: Text);
BEGIN
  WITH Form^ DO BEGIN
    Writeln(Out, '  ,-------------------------------.');
    Writeln(Out, ',-'' Web Developer Application    `-----------------------------------------.');
    Writeln(Out, '|                                                                           |');
    Writeln(Out, '`---------------------------------------------------------------------------''');
    Writeln(Out, '');
    Writeln(Out, 'Years Designing web sites   : ', Years.GetValue);
    Writeln(Out, 'Number of sites produced    : ', TotSites.GetValue);
    Writeln(Out, 'How much time does it take to code a web site?    : ', Time.GetValue);
    Writeln(Out, 'How often can you produce a site/page for ACiD?   : ', HowOften.GetValue);
    Writeln(Out, 'What OS''s are you familiar with?           : ', OS.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'What CGI programming and scripting languages are you fluent in?');
    Writeln(Out, Languages1.GetValue);
    Writeln(Out, Languages2.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'What sort of websites can you develop/wish to develop with ACiD :');
    Writeln(Out, WebType1.GetValue);
    Writeln(Out, WebType2.GetValue);
    Writeln(Out, WebType3.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'Additional Comments:');
    Writeln(Out, Comments1.GetValue);
    Writeln(Out, Comments2.GetValue);
    Writeln(Out, '');
  END;
END;


{$F+} { Exitproc must be "far" }
PROCEDURE Cleanup;
BEGIN
  { Dispose (destruct) objects }
  WITH Form^ DO BEGIN
     Years.Done;
     TotSites.Done;
     Time.Done;
     HowOften.Done;
     OS.Done;
     Languages1.Done;
     Languages2.Done;
     WebType1.Done;
     WebType2.Done;
     WebType3.Done;
     Comments1.Done;
     Comments2.Done;
  END;

  Dispose(Form);

  { And revert to original ExitProc }
  ExitProc:=SaveExitProc;
END;
{$F-}


BEGIN
  New(Form);
  FillChar(Form^, sizeof(Form^), 0);

  { Install cleanup routine }
  SaveExitProc:= ExitProc;
  ExitProc:=@Cleanup;

  { One time initialization of Form }
  WITH Form^ DO BEGIN
     Years.Init(57, 5, '###');
     Years.SetPadChar('.');

     TotSites.Init(57, 6, '####');
     TotSites.SetPadChar('.');

     Time.Init(57, 7, 22, 50);
     Time.SetPadChar('.');

     HowOften.Init(57, 8, 22, 50);
     HowOften.SetPadChar('.');

     OS.Init(57, 9, 22, 50);
     OS.SetPadChar('.');

     Languages1.Init(2, 12, 77, 77);
     Languages1.SetPadChar('.');

     Languages2.Init(2, 13, 77, 77);
     Languages2.SetPadChar('.');

     WebType1.Init(2, 16, 77, 77);
     WebType1.SetPadChar('.');

     WebType2.Init(2, 17, 77, 77);
     WebType2.SetPadChar('.');

     WebType3.Init(2, 18, 77, 77);
     WebType3.SetPadChar('.');

     Comments1.Init(2, 21, 77, 77);
     Comments1.SetPadChar('.');

     Comments2.Init(2, 22, 77, 77);
     Comments2.SetPadChar('.');

     Comments3.Init(2, 23, 77, 77);
     Comments3.SetPadChar('.');
  END;
END.
