Unit AF_HIREZ;     { Hirez Artist information }

{--------------------------------------------------------------------------------}
INTERFACE
{--------------------------------------------------------------------------------}

{           1         2         3         4         5         6         7         8
   12345678901234567890123456789012345678901234567890123456789012345678901234567890
 5|                                 Years drawing hirez : [...]
 6|                 Number of pieces produced (approx.) : [....]
 7|  How much time does it take you to complete one VGA : [......................]
 8|  How many pieces can you produce per month for ACiD : [....]
 9|                           Favorite drawing programs : [......................]
10|                                                       [......................]
11|Preferred resolution mode (1024x768, 800x600, other) : [......................]
12|
13|What are you best at (pics, logos, photomanip, other) :
14|[.............................................................................]
15|
16|Favorite Hirez Artists :
17|[.............................................................................]
18|
19|Additional Comments :
20|[.............................................................................]
21|[.............................................................................]
22|[.............................................................................]
23|[.............................................................................]
}

FUNCTION  Entry(Page, NumPages, Direction : Integer) : Integer;
PROCEDURE Store(VAR Out: Text);

{--------------------------------------------------------------------------------}
IMPLEMENTATION
{--------------------------------------------------------------------------------}

USES  CRTVGA,
      Support,
      TOTFast, TOTIO1, TOTIO2, TOTIO3, TOTInput, TOTStr;

TYPE  FormType = RECORD
                Years      : PictureIOOBJ;
                TotPieces  : PictureIOOBJ;
                Time       : LateralIOOBJ;
                MonthPiece : PictureIOOBJ;
                DrawingPrg1: LateralIOOBJ;
                DrawingPrg2: LateralIOOBJ;
                FavRez     : LateralIOOBJ;
                BestAt     : LateralIOOBJ;
                FavArtists : LateralIOOBJ;
                Comments1  : LateralIOOBJ;
                Comments2  : LateralIOOBJ;
                Comments3  : LateralIOOBJ;
                Comments4  : LateralIOOBJ;
              END;
VAR   Form         : ^FormType;
      SaveExitProc : POINTER;



{$L APP_HIRE.OBJ}
PROCEDURE APP_HIREZ; External;


FUNCTION Entry(Page, NumPages, Direction : Integer) : Integer;
VAR   Manager     : FormOBJ;
      Result      : tAction;
      UpKey,
      DownKey,
      TabKey,
      ShiftTabKey,
      EnterKey,
      PgDnKey,
      PgUpKey,
      F10Key      : HotKeyIOOBJ;

BEGIN
  { Initialize (construct) Objects Entry }
  Manager.Init;
  UpKey.Init      (KEY_Up,      PrevField);
  DownKey.Init    (KEY_Down,    NextField);
  EnterKey.Init   (KEY_Enter,   NextField);
  TabKey.Init     (KEY_Tab,     NextField);
  ShiftTabKey.Init(KEY_ShiftTab,PrevField);
  PgUpKey.Init    (KEY_PgUp,    Stop1);
  PgDnKey.Init    (KEY_PgDn,    Stop2);
  F10Key.Init     (KEY_F10,     Stop3);

  { Show Form Screen }
  SlideForm(@APP_HIREZ, Page, NumPages, Direction);

  WITH Manager DO BEGIN
     { Add special keys }
     AddItem(UpKey);
     AddItem(DownKey);
     AddItem(EnterKey);
     AddItem(TabKey);
     AddItem(ShiftTabKey);
     IF (Page>1) THEN
        AddItem(PgUpKey);
     IF (Page<NumPages) THEN
        AddItem(PgDnKey);
     IF (Page=NumPages) THEN
        AddItem(F10Key);
     { Input items }
     AddItem(Form^.Years);
     AddItem(Form^.TotPieces);
     AddItem(Form^.Time);
     AddItem(Form^.MonthPiece);
     AddItem(Form^.DrawingPrg1);
     AddItem(Form^.DrawingPrg2);
     AddItem(Form^.FavRez);
     AddItem(Form^.BestAt);
     AddItem(Form^.FavArtists);
     AddItem(Form^.Comments1);
     AddItem(Form^.Comments2);
     AddItem(Form^.Comments3);
     AddItem(Form^.Comments4);
  END;

  { Do entry }
  Screen.CursOn;                      { Cursor on }
  IoTot^.SetColField(8, 15, 7, 8);    { Set color for fields. (Inactive field, Active field, Picture (non editable), Readonly }
  Result := Manager.Go;

  { What to do next }
  Case Result of
     Escaped : Entry:=0;
     Stop1   : Entry:=-1;
     Stop2   : Entry:=1;
     Stop3   : Entry:=10;
  END;

  { Dispose (destruct) objects }
  Manager.Done;
  UpKey.Done;
  DownKey.Done;
  EnterKey.Done;
  TabKey.Done;
  ShiftTabKey.Done;
  PgUpKey.Done;
  PgDnKey.Done;
  F10Key.Done;

  { Dirty trick.  Move on screen data back into linked screen.  This makes }
  { paging back to it look better                                          }
  Move(VGA_Memory, @APP_HIREZ^, 4000);
END;


PROCEDURE Store(VAR Out: Text);
BEGIN
  WITH Form^ DO BEGIN
    Writeln(Out, '  ,---------------.');
    Writeln(Out, ',-'' HiRez Artist  `---------------------------------------------------------.');
    Writeln(Out, '|                                                                           |');
    Writeln(Out, '`---------------------------------------------------------------------------''');
    Writeln(Out, '');
    Writeln(Out, 'Years drawing HiRez        : ', Years.GetValue);
    Writeln(Out, 'Number of pieces produced  : ', TotPieces.GetValue);
    Writeln(Out, 'How much time does it take to complete one piece? : ', Time.GetValue);
    Writeln(Out, 'How many pieces can you produce in one month?     : ', MonthPiece.GetValue);
    Writeln(Out, 'What are your favorite drawing program?           : ', DrawingPrg1.GetValue);
    Writeln(Out, '                                                  : ', DrawingPrg2.GetValue);
    Writeln(Out, 'Preferred resolution?                             : ', FavRez.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'What are you best at (Pics, Logos, Photomanip, other):');
    Writeln(Out, BestAt.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'Who are your favorite 3D Artists?:');
    Writeln(Out, FavArtists.GetValue);
    WRiteln(Out, '');
    Writeln(Out, 'Additional Comments:');
    Writeln(Out, Comments1.GetValue);
    Writeln(Out, Comments2.GetValue);
    Writeln(Out, Comments3.GetValue);
    Writeln(Out, Comments4.GetValue);
    Writeln(Out, '');
  END;
END;


{$F+} { Exitproc must be "far" }
PROCEDURE Cleanup;
BEGIN
  { Dispose (destruct) objects }
  WITH Form^ DO BEGIN
     Years.Done;
     TotPieces.Done;
     Time.Done;
     MonthPiece.Done;
     DrawingPrg1.Done;
     DrawingPrg2.Done;
     FavRez.Done;
     BestAt.Done;
     FavArtists.Done;
     Comments1.Done;
     Comments2.Done;
     Comments3.Done;
     Comments4.Done;
  END;

  Dispose(Form);

  { And revert to original ExitProc }
  ExitProc:=SaveExitProc;
END;
{$F-}


BEGIN
  New(Form);
  FillChar(Form^, sizeof(Form^), 0);

  { Install cleanup routine }
  SaveExitProc:= ExitProc;
  ExitProc:=@Cleanup;

  { One time initialization of Form }
  WITH Form^ DO BEGIN
     Years.Init(57, 5, '###');
     Years.SetPadChar('.');

     TotPieces.Init(57, 6, '####');
     TotPieces.SetPadChar('.');

     Time.Init(57, 7, 22, 50);
     Time.SetPadChar('.');

     MonthPiece.Init(57, 8, '####');
     MonthPiece.SetPadChar('.');

     DrawingPrg1.Init(57, 9, 22, 50);
     DrawingPrg1.SetPadChar('.');

     DrawingPrg2.Init(57, 10, 22, 50);
     DrawingPrg2.SetPadChar('.');

     FavRez.Init(57, 11, 22, 50);
     FavRez.SetPadChar('.');

     BestAt.Init(2, 14, 77, 77);
     BestAt.SetPadChar('.');

     FavArtists.Init(2, 17, 77, 77);
     FavArtists.SetPadChar('.');

     Comments1.Init(2, 20, 77, 77);
     Comments1.SetPadChar('.');

     Comments2.Init(2, 21, 77, 77);
     Comments2.SetPadChar('.');

     Comments3.Init(2, 22, 77, 77);
     Comments3.SetPadChar('.');

     Comments4.Init(2, 23, 77, 77);
     Comments4.SetPadChar('.');
  END;
END.
