Unit AF_GENER;     { General information }

{--------------------------------------------------------------------------------}
INTERFACE
{--------------------------------------------------------------------------------}

{           1         2         3         4         5         6         7         8
   12345678901234567890123456789012345678901234567890123456789012345678901234567890
16|       Handle : [.<-50->...................] Age          : [...]
17| Abbreviation : [...]                        Yrs in scene : [...]
18|    Real Name : [..........................] Are you a SiteOp? [N]
19|  Voice Phone : [...][...............]       Site Name    : [.................]
20|   Data Phone : [...][...............]       Site Address : [.................]
21|Daytime Phone : [...][...............]       Previous group experience :
22|Email Address : [..........................] [................................]
23|  City, State : [..........................] [................................]
24|Additional Comments : [.......................................................]
}

FUNCTION  Entry(Page, NumPages, Direction : Integer) : Integer;
PROCEDURE Store(VAR Out: Text);

FUNCTION  GetAbbv : String;

{--------------------------------------------------------------------------------}
IMPLEMENTATION
{--------------------------------------------------------------------------------}

USES  CRTVGA,
      Support,
      TOTFast, TOTIO1, TOTIO2, TOTIO3, TOTInput, TOTStr;

TYPE  FormType =  RECORD
                Handle     : LateralIOOBJ;
                Abbv       : LateralIOOBJ;
                RealName   : LateralIOOBJ;
                Voice      : PictureIOOBJ;
                Data       : PictureIOOBJ;
                Daytime    : PictureIOOBJ;
                Email      : LateralIOOBJ;
                CityST     : LateralIOOBJ;
                Age        : PictureIOOBJ;
                Years      : PictureIOOBJ;
                SiteOp     : PictureIOOBJ;
                SiteName   : LateralIOOBJ;
                SiteAddress: LateralIOOBJ;
                Previous1  : LateralIOOBJ;
                Previous2  : LateralIOOBJ;
                Comments   : LateralIOOBJ;
              END;
VAR   Form         : ^FormType;
      SaveExitProc : POINTER;



{$L APP_GENERAL.OBJ}
PROCEDURE APP_GENERAL; External;


{$F+}
FUNCTION CheckPress(var K:word; VAR X,Y: byte; VAR FieldID:word): tAction;
BEGIN
  Form^.SiteName.SetActiveStatus( Form^.SiteOp.GetValue='Y' );
  Form^.SiteAddress.SetActiveStatus( Form^.SiteOp.GetValue='Y' );
END;
{$F-}


FUNCTION Entry(Page, NumPages, Direction : Integer) : Integer;
VAR   Manager     : FormOBJ;
      Result      : tAction;
      UpKey,
      DownKey,
      TabKey,
      ShiftTabKey,
      EnterKey,
      PgDnKey,
      PgUpKey,
      F10Key      : HotKeyIOOBJ;

BEGIN
  { Initialize (construct) Objects Entry }
  Manager.Init;
  UpKey.Init      (KEY_Up,      PrevField);
  DownKey.Init    (KEY_Down,    NextField);
  EnterKey.Init   (KEY_Enter,   NextField);
  TabKey.Init     (KEY_Tab,     NextField);
  ShiftTabKey.Init(KEY_ShiftTab,PrevField);
  PgUpKey.Init    (KEY_PgUp,    Stop1);
  PgDnKey.Init    (KEY_PgDn,    Stop2);
  F10Key.Init     (KEY_F10,     Stop3);

  { Show Form Screen }
  SlideForm(@APP_GENERAL, Page, NumPages, Direction);

  WITH Manager DO BEGIN
     { Add special keys }
     AddItem(UpKey);
     AddItem(DownKey);
     AddItem(EnterKey);
     AddItem(TabKey);
     AddItem(ShiftTabKey);
     IF (Page>1) THEN
        AddItem(PgUpKey);
     IF (Page<NumPages) THEN
        AddItem(PgDnKey);
     IF (Page=NumPages) THEN
        AddItem(F10Key);
     { Input items }
     AddItem(Form^.Handle);
     AddItem(Form^.Abbv);
     AddItem(Form^.RealName);
     AddItem(Form^.Voice);
     AddItem(Form^.Data);
     AddItem(Form^.Daytime);
     AddItem(Form^.Email);
     AddItem(Form^.CityST);
     AddItem(Form^.Age);
     AddItem(Form^.Years);
     AddItem(Form^.SiteOp);
     AddItem(Form^.SiteName);
     AddItem(Form^.SiteAddress);
     AddItem(Form^.Previous1);
     AddItem(Form^.Previous2);
     AddItem(Form^.Comments);
     { Set hook }
     SetCharHook(CheckPress);  { Enable/Disable of SiteOp fields }
  END;

  { Do entry }
  Screen.CursOn;                      { Cursor on }
  IoTot^.SetColField(8, 15, 7, 8);    { Set color for fields. (Inactive field, Active field, Picture (non editable), Readonly }
  Result := Manager.Go;

  { What to do next }
  Case Result of
     Escaped : Entry:=0;
     Stop1   : Entry:=-1;
     Stop2   : Entry:=1;
     Stop3   : Entry:=10;
  END;

  { Dispose (destruct) objects }
  Manager.Done;
  UpKey.Done;
  DownKey.Done;
  EnterKey.Done;
  TabKey.Done;
  ShiftTabKey.Done;
  PgUpKey.Done;
  PgDnKey.Done;
  F10Key.Done;

  { Dirty trick.  Move on screen data back into linked screen.  This makes }
  { paging back to it look better                                          }
  Move(VGA_Memory, @APP_GENERAL^, 4000);
END;


PROCEDURE Store(VAR Out: Text);
BEGIN
  WITH Form^ DO BEGIN
    Writeln(Out, '  ,---------------.');
    Writeln(Out, ',-'' General Info  `---------------------------------------------------------.');
    Writeln(Out, '|                                                                           |');
    Writeln(Out, '`---------------------------------------------------------------------------''');
    Writeln(Out, '');
    Writeln(Out, 'Handle        : ', Handle.GetValue);
    Writeln(Out, 'Abbreviation  : ', Abbv.GetValue);
    Writeln(Out, 'Real Name     : ', RealName.GetValue);
    Writeln(Out, 'Voice Phone   : ', Voice.GetPicValue);
    Writeln(Out, 'Data Phone    : ', Data.GetPicValue);
    Writeln(Out, 'Daytime Phone : ', DayTime.GetPicValue);
    Writeln(Out, 'Email Address : ', Email.GetValue);
    Writeln(Out, 'City, State   : ', CityST.GetValue);
    Writeln(Out, 'Age           : ', Age.GetValue);
    Writeln(Out, 'Years BBSing  : ', Years.GetValue);
    IF (SiteOp.GetValue='Y') THEN BEGIN
       Writeln(Out, ' SiteOp ?     : Yes');
       Writeln(Out, ' Site Name    : ', SiteName.GetValue);
       Writeln(Out, ' Site Address : ', SiteAddress.GetValue);
    END;
    Writeln(Out, 'Previous Groups: ');
    Writeln(Out, '  > ', Previous1.GetValue, ' ', Previous2.GetValue);
    Writeln(Out, 'Comments      : ');
    Writeln(Out, '  > ', Comments.GetValue);
    Writeln(Out, '');
  END;
END;


FUNCTION GetAbbv : String;
BEGIN
  GetAbbv:=Form^.Abbv.GetValue;
END;


{$F+} { Exitproc must be "far" }
PROCEDURE Cleanup;
BEGIN
  { Dispose (destruct) objects }
  WITH Form^ DO BEGIN
     Handle.Done;
     Abbv.Done;
     RealName.Done;
     Voice.Done;
     Data.Done;
     Daytime.Done;
     Email.Done;
     CityST.Done;
     Age.Done;
     Years.Done;
     SiteOp.Done;
     SiteName.Done;
     SiteAddress.Done;
     Previous1.Done;
     Previous2.Done;
     Comments.Done;
  END;

  Dispose(Form);

  { And revert to original ExitProc }
  ExitProc:=SaveExitProc;
END;
{$F-}


BEGIN
  New(Form);
  FillChar(Form^, sizeof(Form^), 0);

  { Install cleanup routine }
  SaveExitProc:= ExitProc;
  ExitProc:=@Cleanup;

  { One time initialization of Form }
  WITH Form^ DO BEGIN
     Handle.Init(18, 16, 26, 50);
     Handle.SetPadChar('.');

     Abbv.Init(18, 17, 3, 3);
     Abbv.SetPadChar('.');
     Abbv.SetForceCase(True);
     Abbv.SetCase(Upper);

     RealName.Init(18, 18, 26, 50);
     RealName.SetPadChar('.');

     Voice.Init(17, 19, '[###][###############]');
     Voice.SetPadChar('.');

     Data.Init(17, 20, '[###][###############]');
     Data.SetPadChar('.');

     Daytime.Init(17, 21, '[###][###############]');
     Daytime.SetPadChar('.');

     Email.Init(18, 22, 26, 50);
     Email.SetPadChar('.');

     CityST.Init(18, 23, 26, 50);
     CityST.SetPadChar('.');

     Age.Init(62, 16, '###');
     Age.SetPadChar('.');

     Years.Init(62, 17, '###');
     Years.SetPadChar('.');

     SiteOp.Init(65, 18, '!');
     SiteOp.SetAllowChar('ynYN');
     SiteOp.SetPadChar('.');
     SiteOp.SetValue('N');

     SiteName.Init(62, 19, 17, 50);
     SiteName.SetPadChar('.');
     SiteName.SetActiveStatus(False);

     SiteAddress.Init(62, 20, 17, 50);
     SiteAddress.SetPadChar('.');
     SiteAddress.SetActiveStatus(False);

     Previous1.Init(47, 22, 32, 32);
     Previous1.SetPadChar('.');

     Previous2.Init(47, 23, 32, 32);
     Previous2.SetPadChar('.');

     Comments.Init(24, 24, 55, 80);
     Comments.SetPadChar('.');
  END;
END.
