/*-----------------------------------------------------------------
 Non Rectangular window example :                                

 file   : XWindow.h

 date   : 26/11/2000
 author : MooZ/Blockos (CRUZ Vincent)                                         
                       (email: blockos@planet-d.net)                        
                       (url  : http://blockos.planet-d.net)                 

 Here's the famous GPL :
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with This program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

----------------------------------------------------------------------*/

#ifndef XWINDOW_H
#define XWINDOW_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <ctype.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/extensions/shape.h>
#include <X11/xpm.h>

typedef struct{
  Display              *display; 
  int                  screen;   
  
  int                  screenWidth;  /* Width of the screen */ 
  int                  screenHeight; /* Height of the screen */
  
  int                  depth;        /* screen depth*/
  
  int                  width;       /* window width */
  int                  height;      /* height height */
  
  Window               win;       /* Program Window */
  Window               winRoot;   /* Root Window */
  
  XSetWindowAttributes winAttr;   /* Window attributes to set */
  unsigned long        winMask;   /* Attributes Mask */
  XSizeHints           winHint;   /* Window Geometry (used by the window manager) */

  Visual               *visual;

  GC                   gc;        /* Graphic Context */
  XGCValues            gcVal;     /* GC Attributes */
  unsigned long        gcMask;    /* GC Mask */
  
  Pixmap bgPix;                   /* Background Pixmap */
  Pixmap bgMask;                  /* Backgound Pixmap Mask (used to set the window geometry) */
 
}XWindow;

void InitXWindow    ( char*, char*, char*, XWindow* );
void CloseXWindow   ( XWindow* );

#endif



