/*************************************************************************************************
*
*	Title:	VVideo.h
*	Desc:	Virtual Video data types and functions
*	
*	Note:	1) Not this is anything to do with porn
*			
**************************************************************************************************/
#ifndef VVIDEO_H
#define VVIDEO_H

/*************************************************************************************************/
// Types
/*************************************************************************************************/

// basic color type
typedef struct
{
	unsigned char b;
	unsigned char g;
	unsigned char r;
	unsigned char a;
} Color32_t;

// function types
typedef int				Open_f( void );
typedef void			Close_f( void );
typedef Color32_t		*GetAddress_f( void );
typedef void			Flip_f( void );

// Driver 
typedef struct
{
	char				*Description;
	Open_f				*Open;
	Close_f				*Close;
	GetAddress_f		*GetAddress;
	Flip_f				*Flip;
} Driver_t;

/*************************************************************************************************/
// Global Functions
/*************************************************************************************************/

void VV_Init( void );
void VV_Kill( void );
int VV_GetNumberDrivers( void );
int VV_GetCurrentDriver( void );
char *VV_GetDriverDesc( int DriverNo );
void VV_SetDriver( int DriverNo );

// Virtual Video Interface
extern GetAddress_f	*VV_GetAddress;
extern Flip_f		*VV_Flip;

#endif //VVIDEO_H
