;-------------------------------------
; Parte central. Calle con el jeep
;-------------------------------------
BTF2_ZonaCalle_Bitplane_Width  = 44
BTF2_Calle_Bitplane_Width  = 40
BTF2_ZonaCalle_Bitplane_Height = 134
BTF2_Calle_NumPlanosImagen = 5
BTF2_Calle_Tamano_Plano = BTF2_Calle_Bitplane_Width * BTF2_Calle_Bitplane_Height

BTF2_PosX_Jeep=40/8
BTF2_PosY_Jeep=40
BTF2_Altura_Jeep = 92
BTF2_Ancho_Jeep = 16 		;en words 256 pixels

BTF2_Frames_Jeep = 25
BTF2_Frames_Fondo = 1 

BTF2_Division_Frames = 0

DEGRADE=60	; nb couleurs dans le dégradé
NB_DEGR=13	; nb répétitions du dégradé dans 1 rouleau
ROLSIZE=DEGRADE*NB_DEGR*2	; taille du rouleau en octets 

;----------------------------------------------------------------------------------
; El truco para que no se vea el scroll por la izquierda al hacer el desplazamiento
; es no poner el ddfstrt habitual ($38) y hacer que el fetch se haga 16 pixels antes
; ($30) y por eso los modulos no son 4 bytes (32 pixels) sino 2, los de la Parte
; derecha.
;----------------------------------------------------------------------------------

BTF2_Calcula_Offset_Y_Desplazamiento MACRO
	clear d0
	clear d1
	move.w 	BTF2_ContadorScroll,d0
	move.w 	d0,d1
	lsr.l 	#4,d0 					;Offset
	
	and.l 	#$0000000f,d1
	move.l 	d1,d4 					;Necesario para la rutina de pintado del jeep! NO QUITAR!
	sub.w 	#$f,d1
	neg.w 	d1
	and.l 	#$0000000f,d1 			;desplazamiento en bits
	mulu.w	#$11,d1 				;Para lograr el numero de pixels a scrollear tanto en planos pares
	
	ENDM


BTF2_Init:
	;-----------------------------------------------------------------------------
	; Punteros a la zona superior en la copperlist
	;-----------------------------------------------------------------------------

	;-----------------------------------------------------------------------------
	; Roller con el copper
	;-----------------------------------------------------------------------------
	lea	Roller1,a0
	bsr	MakeRoller

	lea	Roller2,a0
	bsr	MakeRoller

	;-----------------------------------------------------------------------------
	; Punteros a la zona media (jeep) en la copperlist
	;-----------------------------------------------------------------------------
	move.l	#BTF2_Calle_Buffer,d1 				;Buffer en blanco
	lea.l	BTF2_Copper_BitplanesCalle+2,a2 	;a2 las direcciones e0...

	REPEAT 	d0,BTF1_NumPlanosImagen TIMES
		swap	d1
		move.w	d1,(a2)
		swap	d1
		move.w	d1,4(a2)
		addq.l	#8,a2
		add.l	#BTF2_ZonaCalle_Bitplane_Width,d1
	END_REPEAT

	;-----------------------------------------------------------------------------
	; Datos iniciales del fondo del jeep (tiles)
	;-----------------------------------------------------------------------------
	move.l BTF2_Calle_Buffer,a0
	bsr		BTF2_TilesIniciales 	;a0 @bitmap

	move.l BTF2_Calle_Buffer+4,a0
	bsr		BTF2_TilesIniciales

	;-----------------------------------------------------------------------------
	; Dibujo inicial del jeep (por doble buffer)
	;-----------------------------------------------------------------------------
	moveq	#0,d0
	clear d1
	move.b #$FF,d1
	bsr 	BTF2_Copia_Fondo_Pos_Jeep
	bsr 	BTF2_Dibuja_Jeep
	
	;-----------------------------------------------------------------------------
	; Punteros a la zona inferior (texto) en la copperlist
	;-----------------------------------------------------------------------------
 	lea 	BTF2_Copper_BitplanesInferior+2,a2
 	move.l 	#BTF2_Espacio_Inferior,d1
 	swap	d1
 	move.w 	d1,(a2)
 	swap	d1
 	move.w 	d1,4(a2)

	;-----------------------------------------------------------------------------
	; Copperlist del efecto JEEP.
	;-----------------------------------------------------------------------------
	lea.l	BTF2_CopperList,a1
	move.l	a1,Cop1Lch+CustomBase
	clr.w 	CopJmp1+CustomBase

	rts	;

;La idea es usarlo solo la primera vez para copiar la zona
;en la que esta el jeep.
;En los pasos sucesivos usaremos trucos para no necesitar
;copiar la zona de la pantalla.

BTF2_Copia_Fondo_Pos_Jeep:
	;Origen (en funcion de las coordenadas del jeep y el offset)
	move.l	BTF2_Calle_Buffer,a4
	move.l 	#BTF2_PosY_Jeep*BTF2_ZonaCalle_Bitplane_Width*BTF2_Calle_NumPlanosImagen,d6
	add.l 	#BTF2_PosX_Jeep,d6 	
	move.l 	d6,BTF2_Origen_Fondo_Jeep
	add.l  	d6,a4 	;

	;Destino
	move.l 	BTF2_Buffer_Jeep,a5 	; BTF2_Jeep01_Planes

	gblWaitBlitter

	;------------------ Calculo de los modulos
	move.l  #$09f00000,BltCon0+CustomBase           ;Operacion D=A
	;------------------ Fuentes de datos Origen y destino
	move.l 	a4,BltAPtH+CustomBase
	move.l 	a5,BltDpth+CustomBase
	;------------------ Mascara fuente A
	move.l	#$ffffffff,Bltafwm+CustomBase
	;------------------ Calculo de los modulos
	move.w	#BTF2_ZonaCalle_Bitplane_Width-BTF2_Ancho_Jeep*2,BltAMod+CustomBase
	move.w	#0,BltDMod+CustomBase
	;------------------- Calculo de la ventana Blitter
	move.w	#(BTF2_Altura_Jeep*BTF2_Calle_NumPlanosImagen*64)+BTF2_Ancho_Jeep,BltSize+CustomBase

	rts

;-------------------------------------------------------------------------------------------------
;Tenemos en BTF2_Buffer_Jeep lo que esta debajo del jeep. Como hacemos scroll a la izquierda
;siempre, el siguiente buffer deberia estar formado por los siguientes trozos:
; actual        siguiente
; W0W1W2W3W4    W1W2W3W4W5
; asi que esta funcion copia W1W2W3W400 y el W5 se hara en el paso 2
;-------------------------------------------------------------------------------------------------
BTF2_Copia_Fondo_Pos_Jeep_Truco_P1:
	;Origen y destino.
	movem.l 	BTF2_Buffer_Jeep,a4-a5
	add.l #2,a4

	gblWaitBlitter

	;------------------ Calculo de los modulos
	move.l  #$09f00000,BltCon0+CustomBase           ;Operacion D=A
	;------------------ Fuentes de datos Origen y destino
	move.l 	a4,BltAPtH+CustomBase
	move.l 	a5,BltDpth+CustomBase
	;------------------ Mascara fuente A
	move.l	#$ffffffff,Bltafwm+CustomBase
	;------------------ Calculo de los modulos
	move.w	#2,BltAMod+CustomBase
	move.w	#2,BltDMod+CustomBase
	;------------------- Calculo de la ventana Blitter
	move.w	#(BTF2_Altura_Jeep*BTF2_Calle_NumPlanosImagen*64)+BTF2_Ancho_Jeep-1,BltSize+CustomBase
	rts

BTF2_Copia_Fondo_Pos_Jeep_Truco_P2:
	pushall

	;Destino
	move.l BTF2_Buffer_Jeep+4,a5
	add.l 	#(BTF2_Ancho_Jeep*2)-2,a5

	;Origen
	move.l 	BTF2_Calle_Buffer+4,a4
	add.l 	BTF2_Origen_Fondo_Jeep,a4
	add.l 	#BTF2_Ancho_Jeep*2,a4

	gblWaitBlitter

	;------------------ Calculo de los modulos
	move.l  #$09f00000,BltCon0+CustomBase           ;Operacion D=A
	;------------------ Fuentes de datos Origen y destino
	move.l 	a4,BltAPtH+CustomBase
	move.l 	a5,BltDpth+CustomBase
	;------------------ Mascara fuente A
	move.l	#$ffffffff,Bltafwm+CustomBase
	;------------------ Calculo de los modulos
	move.w	#BTF2_ZonaCalle_Bitplane_Width-1*2,BltAMod+CustomBase
	move.w	#(BTF2_Ancho_Jeep-1)*2,BltDMod+CustomBase
	;------------------- Calculo de la ventana Blitter
	move.w	#(BTF2_Altura_Jeep*BTF2_Calle_NumPlanosImagen*64)+1,BltSize+CustomBase

	popall
	rts



;Solo restauramos los primeros 16 bits, ya que el resto
;se pintan de nuevo con el jeep. 
;Para que esto funcione necesitamos tener el resto de la zona copiada
;en otro buffer.

BTF2_Restaura_Fondo_Truco:
	
	;Origen
	move.l	BTF2_Buffer_Jeep+4,a4

	;Destino
	move.l 	BTF2_Calle_Buffer+4,a5
	add.l 	BTF2_Origen_Fondo_Jeep,a5 	; BTF2_Jeep01_Planes

	gblWaitBlitter

	;------------------ Calculo de los modulos
	move.l  #$09f00000,BltCon0+CustomBase           ;Operacion D=A
	;------------------ Fuentes de datos Origen y destino
	move.l 	a4,BltAPtH+CustomBase
	move.l 	a5,BltDpth+CustomBase
	;------------------ Mascara fuente A
	move.l	#$ffffffff,Bltafwm+CustomBase
	;------------------ Calculo de los modulos
	move.w	#BTF2_ZonaCalle_Bitplane_Width-1*2,BltDMod+CustomBase ;BTF2_Ancho_Jeep
	move.w	#(BTF2_Ancho_Jeep*2)-2,BltAMod+CustomBase 	;30
	;------------------- Calculo de la ventana Blitter
	move.w	#(BTF2_Altura_Jeep*BTF2_Calle_NumPlanosImagen*64)+1,BltSize+CustomBase   ;BTF2_Ancho_Jeep

	rts


;---------------------------------------------
;Parametros: d0 offset
; 			 d1 numero de bits a desplazar
;
; Para poner un bob en las coordenadas deseadas preservando el fondo necesitamos hacer:
; Source A --> Mascara (Por los desplazamientos)
; Source B --> Bob
; Source C --> fondo (Copia del fondo, para ahorrar restaurarlo)
; Dest.  D --> fondo
;--------------------------------------------------------------
;Usa d5,d6,a4 y a5
;---------------------------------------------

BTF2_Dibuja_Jeep:
	
	clear d5
	clear d6
	;---- Coordenadas del Jeep.
	move.w 	#BTF2_PosX_Jeep,d5
	move.w 	#BTF2_PosY_Jeep,d6
	
	;Origen
	lea BTF2_Jeep_Frames,a4
	move.l 	(a4),a4

	;Mascara
	lea		BTF2_Jeep_Mascaras,a6
	move.l 	(a6),a6
	
	;Destino
	move.l BTF2_Calle_Buffer+4,a5

	mulu.w 	#BTF2_ZonaCalle_Bitplane_Width*BTF2_Calle_NumPlanosImagen,d6
	;offset
	add.l 	d0,a5
	add.l 	d0,a5
	;Por la coordenada Y
	add.l 	d6,a5
	;Por la coordenada X
	add.l 	d5,a5

	;fondo copiado
	lea 	BTF2_Buffer_Jeep,a3
	move.l 	(a3),a3

	;------------------ Calculo de los modulos
	clear 	d6
	move.w 	d4,d6 	;d4 los bits a desplazar a la derecha
	lsl.w 	#8,d6
	lsl.w   #4,d6

	and.l 	#$0000F000,d6
	
	gblWaitBlitter

	move.w	d6,BltCon1+CustomBase 	;Para desplazar el bob
	add.w 	#$0fca,d6
	move.w  d6,BltCon0+CustomBase   ;desplaza mask y Operacion D=A+B+C

	;------------------ Fuentes de datos Origen y destino
	move.l 	a6,BltAPtH+CustomBase
	move.l 	a4,BltBPtH+CustomBase
	move.l 	a3,BltCPtH+CustomBase	
	move.l 	a5,BltDpth+CustomBase
	;------------------ Mascara fuente A
	move.l	#$ffffffff,Bltafwm+CustomBase
	;------------------ Calculo de los modulos
	move.w	#0,BltAMod+CustomBase
	move.w	#0,BltBMod+CustomBase
	move.w	#0,BltCMod+CustomBase

	move.w	#BTF2_ZonaCalle_Bitplane_Width-(BTF2_Ancho_Jeep*2),BltDMod+CustomBase
	;------------------- Calculo de la ventana Blitter
	move.w	#(BTF2_Altura_Jeep*BTF2_Calle_NumPlanosImagen*64)+BTF2_Ancho_Jeep,BltSize+CustomBase

	jif.w 	#BTF2_Frames_Jeep,'<>',BTF2_Frames_Jeep_Dibujados,BTF2_Fin_Dibujo_Jeep

	move.w 	#0,BTF2_Frames_Jeep_Dibujados

	movem.l BTF2_Jeep_Frames,a3-a4
	exg 	a3,a4
	movem.l a3-a4,BTF2_Jeep_Frames

	movem.l BTF2_Jeep_Mascaras,a3-a4
	exg 	a3,a4
	movem.l a3-a4,BTF2_Jeep_Mascaras

BTF2_Fin_Dibujo_Jeep:
	add.w 	#1,BTF2_Frames_Jeep_Dibujados

	rts

;--------------------------------------------------------------
; Invocada en cada VBG
;--------------------------------------------------------------
BTF2_Run:

	add.w 	#1,BTF2_ContadorFrames

	bsr 	BTF2_MoveRollers

	cmp.w 	#100,BTF2_ContadorFrames
	bne     .NoPrimerTexto
	gblPrintText8 BTF2_Espacio_Inferior,BTF2_Espacio_Inferior2,0,2,ptextoJeep1,BTF_FontCbm64,BTF_CharTab,BTF_CharTabEnd,8,1,40,1,1

.NoPrimerTexto
	cmp.w 	#300,BTF2_ContadorFrames
	bne     .NoSegundoTexto
	gblPrintText8 BTF2_Espacio_Inferior,BTF2_Espacio_Inferior2,0,3,ptextoJeep2,BTF_FontCbm64,BTF_CharTab,BTF_CharTabEnd,8,1,40,1,1

.NoSegundoTexto
	cmp.w 	#600,BTF2_ContadorFrames
	bne     .NoBorrarTexto
	gblPrintText8 BTF2_Espacio_Inferior,BTF2_Espacio_Inferior2,0,4,ptextoJeep3,BTF_FontCbm64,BTF_CharTab,BTF_CharTabEnd,8,1,40,1,1

.NoBorrarTexto
	cmp.w 	#700,BTF2_ContadorFrames
	bne     BTF2_SoloJeep

	bsr 	BTF2_Borra_Zona_Letras
	
	gblWaitBlitter

	gblPrintText8 BTF2_Espacio_Inferior,BTF2_Espacio_Inferior2,0,5,ptextoJeep3,BTF_FontCbm64,BTF_CharTab,BTF_CharTabEnd,8,1,40,1,1



BTF2_SoloJeep:
	;------------------------------------------------------
	; BTF2_ContadorScroll tiene el numero de ciclos de scroll. 
	; Para saber las posiciones a poner en la copper tenemos
	; que dividir entre 16 y eso es el offset, el resto de 
	; la division nos dice los bits a desplazar.
	;------------------------------------------------------
	;
	;------------------------------------------------------
	; Offset y scroll de la imagen a mostrar.
	;------------------------------------------------------
	BTF2_Calcula_Offset_Y_Desplazamiento
	;------------------------------------------------------
	; Cambio de buffers
	;------------------------------------------------------
	movem.l 	BTF2_Calle_Buffer,a0-a1
	exg		a0,a1
	movem.l 	a0-a1,BTF2_Calle_Buffer
	;------------------------------------------------------
	; Actualiza copper con imagen a mostrar.
	;------------------------------------------------------
	move.w 	d1,BTF2_Scroll_Calle+2 	;Scroll en la copperlist

	add.l 	d0,a0 								;Sumamos el offset * 2
	add.l 	d0,a0 								;porque vamos de 16 en 16 bits
												;Y actualizamos la copperlist.
	move.l 	a0,d1
	lea.l	BTF2_Copper_BitplanesCalle+2,a2 	;a2 las direcciones e0...

	REPEAT 	d0,BTF1_NumPlanosImagen TIMES
		swap	d1
		move.w	d1,(a2)
		swap	d1
		move.w	d1,4(a2)
		addq.l	#8,a2
		add.l	#BTF2_ZonaCalle_Bitplane_Width,d1
	END_REPEAT	

	;------------------------------------------------------
	; Actualiza contador de frames.
	;------------------------------------------------------
	add.w 	#1,BTF2_ContadorScroll
	
	;------------------------------------------------------
	; Offset y scroll de la nueva imagen a mostrar. (Doble buffer)
	;------------------------------------------------------
	BTF2_Calcula_Offset_Y_Desplazamiento


	jif.w 	#$ff,'<>',d1,BTF2_Check_Scroll_00
	
		bsr.w 	BTF2_Restaura_Fondo_Truco

		movem.l 	BTF2_Buffer_Jeep,d5-d6
		exg 	d5,d6
		movem.l 	d5-d6,BTF2_Buffer_Jeep

		tst.w 	BTF2_Pintar_Tile_Dercha
		beq 	BTF2_Check_Scroll_00

		sub.w 	#1,d0  							;Tenemos que restar uno porque al ser el scroll ff
bbb		bsr.w 	BTF2_Pinta_Nuevo_Tile_Derecha	;significa que hemos cambiado de offset y tenemos que
		add.w 	#1,d0 							;pintar el tile "del paso anterior"
		move.w 	#0,BTF2_Pintar_Tile_Dercha
		;Ademas hay que restaurar el fondo por lo mismo.
		bsr 	BTF2_Restaura_Fondo_Truco
		add.l 	#2,BTF2_Origen_Fondo_Jeep


BTF2_Check_Scroll_00:
	jif.w 	#$00,'<>',d1,BTF2_T1
		
		move.W 	BTF2_PosicionTiles,BTF2_PosicionTilesOriginal
		bsr.w 	BTF2_Pinta_Nuevo_Tile_Derecha
		move.W 	BTF2_PosicionTilesOriginal,BTF2_PosicionTiles
		move.w 	#1,BTF2_Pintar_Tile_Dercha

BTF2_T1
	jif.w 	#$77,'<>',d1,BTF2_T2
		bsr.w 	BTF2_Copia_Fondo_Pos_Jeep_Truco_P1
BTF2_T2
	jif.w 	#$33,'<>',d1,BTF2_Pintar_Jeep2
		bsr.w 	BTF2_Copia_Fondo_Pos_Jeep_Truco_P2

BTF2_Pintar_Jeep2
	bsr 	BTF2_Dibuja_Jeep 			;D0 Offset y D1 Bits a desplazar. Usa d5,d6,a4,a5.

BTF2_Fin_Run:

	rts

;--------------------------------------------------------------
; Rellenamos los tiles iniciales de la calle. Como son de 16x134
; tenemos que poner los 20 primeros
; BTF2_Calle_Buffer --> (A0) donde hay que copiar los tiles
; BTF2_Calle_Imagen --> La imagen main
; BTF2_Calle_Tiles  --> La definicion de los tiles. FF es fin
;--------------------------------------------------------------
BTF2_TilesIniciales:
	lea 	BTF2_Calle_Tiles,a2

	REPEAT d0,22 TIMES
		clear 	d1
		lea 	BTF2_Calle_Imagen,a1
		move.b 	(a2)+,d1 	;Numero de tile. 
		;Con el numero de tile calculamos la posicion a copiar. (Origen) 
		lsl.w 	#1,d1  	;Multiplicamos por 2
		add.l 	d1,a1 --> Origen

		gblWaitBlitter
		;------------------ Calculo de los modulos
		move.l  #$09f00000,BltCon0+CustomBase           ;Operacion D=A
		;------------------ Fuentes de datos Origen y destino
		move.l 	a1,BltAPtH+CustomBase
		move.l	#$ffffffff,Bltafwm+CustomBase

		move.l 	a0,BltDpth+CustomBase
		;------------------ Calculo de los modulos
		move.w	#BTF2_Calle_Bitplane_Width-2,BltAMod+CustomBase
		move.w	#BTF2_ZonaCalle_Bitplane_Width-2,BltDMod+CustomBase
		;------------------- Calculo de la ventana Blitter
		move.w	#(BTF2_ZonaCalle_Bitplane_Height*BTF2_Calle_NumPlanosImagen*64)+1,BltSize+CustomBase

		add.l 	#2,a0 		;Direccion inicial del siguiente tile

	END_REPEAT

	move.w 	#23,BTF2_PosicionTiles

	rts


BTF2_Pinta_Nuevo_Tile_Derecha:
	move.l  BTF2_Calle_Buffer+4,a0
	add.l 	#BTF2_ZonaCalle_Bitplane_Width-2,a0
	add.l 	d0,a0
	add.l 	d0,a0

	clear 	d3

	lea 	BTF2_Calle_Tiles,a2
	move.w 	BTF2_PosicionTiles,d3
	add.l 	d3,a2
	cmp.b 	#-1,(a2)
	bne 	.NoResetTiles
	move.w 	#-1,BTF2_PosicionTiles
	lea 	BTF2_Calle_Tiles,a2

.NoResetTiles	
	add.w 	#1,BTF2_PosicionTiles
	lea 	BTF2_Calle_Imagen,a1
	clear 	d3
	move.b 	(a2)+,d3 	;Numero de tile. 
	;Con el numero de tile calculamos la posicion a copiar. (Origen) 
	lsl.l 	#1,d3
	add.l 	d3,a1 --> Origen

	gblWaitBlitter

	move.l  #$09f00000,BltCon0+CustomBase           ;Operacion D=A
	move.l 	a1,BltAPtH+CustomBase
	move.l 	a0,BltDpth+CustomBase	
	move.l	#$ffffffff,Bltafwm+CustomBase
	;------------------ Calculo de los modulos
	move.w	#BTF2_Calle_Bitplane_Width-2,BltAMod+CustomBase
	move.w	#BTF2_ZonaCalle_Bitplane_Width-2,BltDMod+CustomBase
	;------------------ Blitter!!!!!
	move.w	#(BTF2_ZonaCalle_Bitplane_Height*BTF2_Calle_NumPlanosImagen*64)+1,BltSize+CustomBase
	
	rts


; --------------------------------------------------------------------------------------------------
; Animacion Jeep
; --------------------------------------------------------------------------------------------------
MakeRoller:
	moveq	#NB_DEGR-1,d0
.make	moveq	#0,d1

	moveq	#14,d2
.roll1	move.w	#$0180,(a0)+	; rouge 0 -> rouge 15
	move.w	d1,(a0)+
	addi.w	#$010,d1
	dbra	d2,.roll1
	move.w	#$0180,(a0)+
	move.w	d1,(a0)+

	moveq	#14,d2
.roll2	move.w	#$0180,(a0)+	; rouge 14 -> rouge 0
	subi.w	#$0010,d1
	move.w	d1,(a0)+
	dbra	d2,.roll2

	moveq	#14,d2
.roll3	move.w	#$0180,(a0)+	; bleu 1 -> bleu 15
	addi.w	#$0001,d1
	move.w	d1,(a0)+
	dbra	d2,.roll3

	moveq	#13,d2
.roll4	move.w	#$0180,(a0)+	; bleu 14 -> bleu 0
	subi.w	#$0001,d1
	move.w	d1,(a0)+
	dbra	d2,.roll4

	dbra	d0,.make
	rts


BTF2_MoveRollers:
	lea	Roller1+(ROLSIZE*2),a0	; 1er rouleau
	lea	-4(a0),a1
	move.w	-2(a0),d0
	move.w	#(ROLSIZE/2)-2,d1
Avant	move.l	-(a1),-(a0)
	dbra	d1,Avant
	move.w	d0,2(a0)

	lea	Roller2,a0		; 2eme rouleau
	lea	4(a0),a1
	move.w	2(a0),d0
	move.w	#(ROLSIZE/2)-2,d1
Arriere	move.l	(a1)+,(a0)+
	dbra	d1,Arriere
	move.w	d0,-2(a1)

	
	rts
	

BTF2_Borra_Zona_Letras:
	;Destino
	lea 	BTF2_Espacio_Inferior,a5 	; BTF2_Jeep01_Planes

	gblWaitBlitter

	;------------------ Calculo de los modulos
	move.l  #$01000000,BltCon0+CustomBase           ;Operacion D=A
	;------------------ Fuentes de datos Origen y destino
	move.l 	a5,BltDpth+CustomBase
	;------------------ Mascara fuente A
	move.l	#$ffffffff,Bltafwm+CustomBase
	;------------------ Calculo de los modulos
	move.w	#0,BltDMod+CustomBase
	;------------------- Calculo de la ventana Blitter
	move.w	#(80*1*64)+22,BltSize+CustomBase

	rts

; --------------------------------------------------------------------------------------------------
; FIN - Animacion Jeep
; --------------------------------------------------------------------------------------------------

	even

BTF2_ContadorScroll: 	dc.w 	0
BTF2_ContadorFrames:    dc.w 	0

BTF2_PosicionTiles: 	dc.w 	0
BTF2_PosicionTilesOriginal: 	
	dc.w 	0

BTF2_Frames_Jeep_Dibujados: dc.w 0
BTF2_Frames_Fondo_Dibujados: dc.w 0

BTF2_Origen_Fondo_Jeep: dc.l 0
BTF2_Pintar_Tile_Dercha: dc.w 0

ptextoJeep1: 
	dc.b	"      (C) GOBLINS Y AMIGAWAVE 2017      ",0
	even
ptextoJeep2: 
	dc.b	"   INTRO HOMENAJE A REGRESO AL FUTURO   ",0
	even
ptextoJeep3: 
	dc.b	"     PARA POSADAS (MEGABLAST) PARTY     ",0
	even



